/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.math.shapes.triangle;

import lombok.Generated;

public class TriangleF {
    private final float x1;
    private final float y1;
    private final float x2;
    private final float y2;
    private final float x3;
    private final float y3;

    public TriangleF(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.x3 = x3;
        this.y3 = y3;
    }

    public float getX1() {
        return this.x1;
    }

    public float getY1() {
        return this.y1;
    }

    public float getX2() {
        return this.x2;
    }

    public float getY2() {
        return this.y2;
    }

    public float getX3() {
        return this.x3;
    }

    public float getY3() {
        return this.y3;
    }

    public TriangleF translate(float x, float y) {
        return new TriangleF(this.x1 + x, this.y1 + y, this.x2 + x, this.y2 + y, this.x3 + x, this.y3 + y);
    }

    public double getArea() {
        return Math.abs((double)(this.x1 * (this.y2 - this.y3) + this.x2 * (this.y3 - this.y1) + this.x3 * (this.y1 - this.y2)) / 2.0);
    }

    public double getPerimeter() {
        double side1 = Math.hypot(this.x2 - this.x1, this.y2 - this.y1);
        double side2 = Math.hypot(this.x3 - this.x2, this.y3 - this.y2);
        double side3 = Math.hypot(this.x1 - this.x3, this.y1 - this.y3);
        return side1 + side2 + side3;
    }

    public float[] getCentroid() {
        float centroidX = (this.x1 + this.x2 + this.x3) / 3.0f;
        float centroidY = (this.y1 + this.y2 + this.y3) / 3.0f;
        return new float[]{centroidX, centroidY};
    }

    public boolean isPointInside(float px, float py) {
        double area3;
        double area2;
        double areaOrig = this.getArea();
        double area1 = Math.abs((double)(px * (this.y2 - this.y3) + this.x2 * (this.y3 - py) + this.x3 * (py - this.y2)) / 2.0);
        return area1 + (area2 = Math.abs((double)(this.x1 * (py - this.y3) + px * (this.y3 - this.y1) + this.x3 * (this.y1 - py)) / 2.0)) + (area3 = Math.abs((double)(this.x1 * (this.y2 - py) + this.x2 * (py - this.y1) + px * (this.y1 - this.y2)) / 2.0)) == areaOrig;
    }

    public boolean isEquilateral() {
        double side1 = Math.hypot(this.x2 - this.x1, this.y2 - this.y1);
        double side2 = Math.hypot(this.x3 - this.x2, this.y3 - this.y2);
        double side3 = Math.hypot(this.x1 - this.x3, this.y1 - this.y3);
        return side1 == side2 && side2 == side3;
    }

    @Generated
    public String toString() {
        return "TriangleF(x1=" + this.getX1() + ", y1=" + this.getY1() + ", x2=" + this.getX2() + ", y2=" + this.getY2() + ", x3=" + this.getX3() + ", y3=" + this.getY3() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TriangleF)) {
            return false;
        }
        TriangleF other = (TriangleF)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getX1(), other.getX1()) != 0) {
            return false;
        }
        if (Float.compare(this.getY1(), other.getY1()) != 0) {
            return false;
        }
        if (Float.compare(this.getX2(), other.getX2()) != 0) {
            return false;
        }
        if (Float.compare(this.getY2(), other.getY2()) != 0) {
            return false;
        }
        if (Float.compare(this.getX3(), other.getX3()) != 0) {
            return false;
        }
        return Float.compare(this.getY3(), other.getY3()) == 0;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TriangleF;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getX1());
        result = result * 59 + Float.floatToIntBits(this.getY1());
        result = result * 59 + Float.floatToIntBits(this.getX2());
        result = result * 59 + Float.floatToIntBits(this.getY2());
        result = result * 59 + Float.floatToIntBits(this.getX3());
        result = result * 59 + Float.floatToIntBits(this.getY3());
        return result;
    }
}

