/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.math.shapes.triangle;

import lombok.Generated;

public class TriangleD {
    private final double x1;
    private final double y1;
    private final double x2;
    private final double y2;
    private final double x3;
    private final double y3;

    public TriangleD(double x1, double y1, double x2, double y2, double x3, double y3) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.x3 = x3;
        this.y3 = y3;
    }

    public double getX1() {
        return this.x1;
    }

    public double getY1() {
        return this.y1;
    }

    public double getX2() {
        return this.x2;
    }

    public double getY2() {
        return this.y2;
    }

    public double getX3() {
        return this.x3;
    }

    public double getY3() {
        return this.y3;
    }

    public TriangleD translate(double x, double y) {
        return new TriangleD(this.x1 + x, this.y1 + y, this.x2 + x, this.y2 + y, this.x3 + x, this.y3 + y);
    }

    public double getArea() {
        return Math.abs((this.x1 * (this.y2 - this.y3) + this.x2 * (this.y3 - this.y1) + this.x3 * (this.y1 - this.y2)) / 2.0);
    }

    public double getPerimeter() {
        double side1 = Math.hypot(this.x2 - this.x1, this.y2 - this.y1);
        double side2 = Math.hypot(this.x3 - this.x2, this.y3 - this.y2);
        double side3 = Math.hypot(this.x1 - this.x3, this.y1 - this.y3);
        return side1 + side2 + side3;
    }

    public double[] getCentroid() {
        double centroidX = (this.x1 + this.x2 + this.x3) / 3.0;
        double centroidY = (this.y1 + this.y2 + this.y3) / 3.0;
        return new double[]{centroidX, centroidY};
    }

    public boolean isPointInside(double px, double py) {
        double area3;
        double area2;
        double areaOrig = this.getArea();
        double area1 = Math.abs((px * (this.y2 - this.y3) + this.x2 * (this.y3 - py) + this.x3 * (py - this.y2)) / 2.0);
        return area1 + (area2 = Math.abs((this.x1 * (py - this.y3) + px * (this.y3 - this.y1) + this.x3 * (this.y1 - py)) / 2.0)) + (area3 = Math.abs((this.x1 * (this.y2 - py) + this.x2 * (py - this.y1) + px * (this.y1 - this.y2)) / 2.0)) == areaOrig;
    }

    public boolean isEquilateral() {
        double side1 = Math.hypot(this.x2 - this.x1, this.y2 - this.y1);
        double side2 = Math.hypot(this.x3 - this.x2, this.y3 - this.y2);
        double side3 = Math.hypot(this.x1 - this.x3, this.y1 - this.y3);
        return side1 == side2 && side2 == side3;
    }

    @Generated
    public String toString() {
        return "TriangleD(x1=" + this.getX1() + ", y1=" + this.getY1() + ", x2=" + this.getX2() + ", y2=" + this.getY2() + ", x3=" + this.getX3() + ", y3=" + this.getY3() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TriangleD)) {
            return false;
        }
        TriangleD other = (TriangleD)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getX1(), other.getX1()) != 0) {
            return false;
        }
        if (Double.compare(this.getY1(), other.getY1()) != 0) {
            return false;
        }
        if (Double.compare(this.getX2(), other.getX2()) != 0) {
            return false;
        }
        if (Double.compare(this.getY2(), other.getY2()) != 0) {
            return false;
        }
        if (Double.compare(this.getX3(), other.getX3()) != 0) {
            return false;
        }
        return Double.compare(this.getY3(), other.getY3()) == 0;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TriangleD;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $x1 = Double.doubleToLongBits(this.getX1());
        result = result * 59 + (int)($x1 >>> 32 ^ $x1);
        long $y1 = Double.doubleToLongBits(this.getY1());
        result = result * 59 + (int)($y1 >>> 32 ^ $y1);
        long $x2 = Double.doubleToLongBits(this.getX2());
        result = result * 59 + (int)($x2 >>> 32 ^ $x2);
        long $y2 = Double.doubleToLongBits(this.getY2());
        result = result * 59 + (int)($y2 >>> 32 ^ $y2);
        long $x3 = Double.doubleToLongBits(this.getX3());
        result = result * 59 + (int)($x3 >>> 32 ^ $x3);
        long $y3 = Double.doubleToLongBits(this.getY3());
        result = result * 59 + (int)($y3 >>> 32 ^ $y3);
        return result;
    }
}

