/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.math.shapes.rect;

import lombok.Generated;

public class RectI {
    public static final RectI ZERO = new RectI(0, 0, 0, 0);
    private final int x;
    private final int y;
    private final int width;
    private final int height;

    public RectI(int width, int height) {
        this(0, 0, width, height);
    }

    public RectI(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public RectI translate(int x, int y) {
        return new RectI(this.x + x, this.y + y, this.width, this.height);
    }

    public int getArea() {
        return this.width * this.height;
    }

    public boolean isSquare() {
        return this.width == this.height;
    }

    public RectI scale(int scale) {
        return this.scale(scale, scale);
    }

    public RectI scale(int scaleX, int scaleY) {
        return new RectI(this.width * scaleX, this.height * scaleY);
    }

    public boolean intersects(RectI rect) {
        return this.x < rect.x + rect.width && this.x + this.width > rect.x && this.y < rect.y + rect.height && this.y + this.height > rect.y;
    }

    public boolean contains(RectI rect) {
        return this.x <= rect.x && this.x + this.width >= rect.x + rect.width && this.y <= rect.y && this.y + this.height >= rect.y + rect.height;
    }

    public RectI intersection(RectI rect) {
        if (!this.intersects(rect)) {
            return ZERO;
        }
        int x = Math.max(this.x, rect.x);
        int y = Math.max(this.y, rect.y);
        int width = Math.min(this.x + this.width, rect.x + rect.width) - x;
        int height = Math.min(this.y + this.height, rect.y + rect.height) - y;
        return new RectI(x, y, width, height);
    }

    @Generated
    public String toString() {
        return "RectI(x=" + this.getX() + ", y=" + this.getY() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RectI)) {
            return false;
        }
        RectI other = (RectI)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getY() != other.getY()) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        return this.getHeight() == other.getHeight();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RectI;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getY();
        result = result * 59 + this.getWidth();
        result = result * 59 + this.getHeight();
        return result;
    }
}

