/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.math.shapes.rect;

import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;

@Deprecated
@ApiStatus.ScheduledForRemoval
public class Rect2i {
    public static final Rect2i ZERO = new Rect2i(0, 0, 0, 0);
    private final int x;
    private final int y;
    private final int width;
    private final int height;

    public Rect2i(int width, int height) {
        this(0, 0, width, height);
    }

    public Rect2i(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getArea() {
        return this.width * this.height;
    }

    public boolean isSquare() {
        return this.width == this.height;
    }

    public Rect2i scale(int scale) {
        return this.scale(scale, scale);
    }

    public Rect2i scale(int scaleX, int scaleY) {
        return new Rect2i(this.width * scaleX, this.height * scaleY);
    }

    public boolean intersects(Rect2i rect) {
        return this.x < rect.x + rect.width && this.x + this.width > rect.x && this.y < rect.y + rect.height && this.y + this.height > rect.y;
    }

    public boolean contains(Rect2i rect) {
        return this.x <= rect.x && this.x + this.width >= rect.x + rect.width && this.y <= rect.y && this.y + this.height >= rect.y + rect.height;
    }

    public Rect2i intersection(Rect2i rect) {
        if (!this.intersects(rect)) {
            return ZERO;
        }
        int x = Math.max(this.x, rect.x);
        int y = Math.max(this.y, rect.y);
        int width = Math.min(this.x + this.width, rect.x + rect.width) - x;
        int height = Math.min(this.y + this.height, rect.y + rect.height) - y;
        return new Rect2i(x, y, width, height);
    }

    @Generated
    public String toString() {
        return "Rect2i(x=" + this.getX() + ", y=" + this.getY() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rect2i)) {
            return false;
        }
        Rect2i other = (Rect2i)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getY() != other.getY()) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        return this.getHeight() == other.getHeight();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Rect2i;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getY();
        result = result * 59 + this.getWidth();
        result = result * 59 + this.getHeight();
        return result;
    }
}

