/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.math.shapes.rect;

import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;

@Deprecated
@ApiStatus.ScheduledForRemoval
public class Rect2f {
    public static final Rect2f ZERO = new Rect2f(0.0f, 0.0f, 0.0f, 0.0f);
    private final float x;
    private final float y;
    private final float width;
    private final float height;

    public Rect2f(float width, float height) {
        this(0.0f, 0.0f, width, height);
    }

    public Rect2f(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float getArea() {
        return this.width * this.height;
    }

    public boolean isSquare() {
        return this.width == this.height;
    }

    public Rect2f scale(float scale) {
        return this.scale(scale, scale);
    }

    public Rect2f scale(float scaleX, float scaleY) {
        return new Rect2f(this.width * scaleX, this.height * scaleY);
    }

    public boolean intersects(Rect2f rect) {
        return this.x < rect.x + rect.width && this.x + this.width > rect.x && this.y < rect.y + rect.height && this.y + this.height > rect.y;
    }

    public boolean contains(Rect2f rect) {
        return this.x <= rect.x && this.x + this.width >= rect.x + rect.width && this.y <= rect.y && this.y + this.height >= rect.y + rect.height;
    }

    public Rect2f intersection(Rect2f rect) {
        if (!this.intersects(rect)) {
            return ZERO;
        }
        float x = Math.max(this.x, rect.x);
        float y = Math.max(this.y, rect.y);
        float width = Math.min(this.x + this.width, rect.x + rect.width) - x;
        float height = Math.min(this.y + this.height, rect.y + rect.height) - y;
        return new Rect2f(x, y, width, height);
    }

    @Generated
    public String toString() {
        return "Rect2f(x=" + this.getX() + ", y=" + this.getY() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rect2f)) {
            return false;
        }
        Rect2f other = (Rect2f)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Float.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Float.compare(this.getWidth(), other.getWidth()) != 0) {
            return false;
        }
        return Float.compare(this.getHeight(), other.getHeight()) == 0;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Rect2f;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getX());
        result = result * 59 + Float.floatToIntBits(this.getY());
        result = result * 59 + Float.floatToIntBits(this.getWidth());
        result = result * 59 + Float.floatToIntBits(this.getHeight());
        return result;
    }
}

