/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.math.shapes.rect;

import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;

@Deprecated
@ApiStatus.ScheduledForRemoval
public class Rect2d {
    public static final Rect2d ZERO = new Rect2d(0.0, 0.0, 0.0, 0.0);
    private final double x;
    private final double y;
    private final double width;
    private final double height;

    public Rect2d(double width, double height) {
        this(0.0, 0.0, width, height);
    }

    public Rect2d(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getArea() {
        return this.width * this.height;
    }

    public boolean isSquare() {
        return this.width == this.height;
    }

    public Rect2d scale(double scale) {
        return this.scale(scale, scale);
    }

    public Rect2d scale(double scaleX, double scaleY) {
        return new Rect2d(this.width * scaleX, this.height * scaleY);
    }

    public boolean intersects(Rect2d rect) {
        return this.x < rect.x + rect.width && this.x + this.width > rect.x && this.y < rect.y + rect.height && this.y + this.height > rect.y;
    }

    public boolean contains(Rect2d rect) {
        return this.x <= rect.x && this.x + this.width >= rect.x + rect.width && this.y <= rect.y && this.y + this.height >= rect.y + rect.height;
    }

    public Rect2d intersection(Rect2d rect) {
        if (!this.intersects(rect)) {
            return ZERO;
        }
        double x = Math.max(this.x, rect.x);
        double y = Math.max(this.y, rect.y);
        double width = Math.min(this.x + this.width, rect.x + rect.width) - x;
        double height = Math.min(this.y + this.height, rect.y + rect.height) - y;
        return new Rect2d(x, y, width, height);
    }

    @Generated
    public String toString() {
        return "Rect2d(x=" + this.getX() + ", y=" + this.getY() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rect2d)) {
            return false;
        }
        Rect2d other = (Rect2d)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getWidth(), other.getWidth()) != 0) {
            return false;
        }
        return Double.compare(this.getHeight(), other.getHeight()) == 0;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Rect2d;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $width = Double.doubleToLongBits(this.getWidth());
        result = result * 59 + (int)($width >>> 32 ^ $width);
        long $height = Double.doubleToLongBits(this.getHeight());
        result = result * 59 + (int)($height >>> 32 ^ $height);
        return result;
    }
}

