/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.math.shapes.point;

import lombok.Generated;

public class Point3I {
    private final int x;
    private final int y;
    private final int z;

    public Point3I(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public Point3I add(int value) {
        return this.add(value, value, value);
    }

    public Point3I add(int x, int y, int z) {
        return new Point3I(this.x + x, this.y + y, this.z + z);
    }

    public Point3I add(Point3I point) {
        return this.add(point.getX(), point.getY(), point.getZ());
    }

    public Point3I subtract(int value) {
        return this.subtract(value, value, value);
    }

    public Point3I subtract(int x, int y, int z) {
        return new Point3I(this.x - x, this.y - y, this.z - z);
    }

    public Point3I subtract(Point3I point) {
        return this.subtract(point.getX(), point.getY(), point.getZ());
    }

    public Point3I multiply(int value) {
        return this.multiply(value, value, value);
    }

    public Point3I multiply(int x, int y, int z) {
        return new Point3I(this.x * x, this.y * y, this.z * z);
    }

    public Point3I multiply(Point3I point) {
        return this.multiply(point.getX(), point.getY(), point.getZ());
    }

    public Point3I divide(int value) {
        return this.divide(value, value, value);
    }

    public Point3I divide(int x, int y, int z) {
        return new Point3I(this.x / x, this.y / y, this.z / z);
    }

    public Point3I divide(Point3I point) {
        return this.divide(point.getX(), point.getY(), point.getZ());
    }

    public double distanceSquared(int x, int y, int z) {
        return Math.pow(this.x - x, 2.0) + Math.pow(this.y - y, 2.0) + Math.pow(this.z - z, 2.0);
    }

    public double distanceSquared(Point3I point) {
        return this.distanceSquared(point.getX(), point.getY(), point.getZ());
    }

    public double distance(int x, int y, int z) {
        return Math.sqrt(this.distanceSquared(x, y, z));
    }

    public double distance(Point3I point) {
        return this.distance(point.getX(), point.getY(), point.getZ());
    }

    @Generated
    public String toString() {
        return "Point3I(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Point3I)) {
            return false;
        }
        Point3I other = (Point3I)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getY() != other.getY()) {
            return false;
        }
        return this.getZ() == other.getZ();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Point3I;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getY();
        result = result * 59 + this.getZ();
        return result;
    }
}

