/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.math.shapes.point;

import lombok.Generated;

public class Point3F {
    private final float x;
    private final float y;
    private final float z;

    public Point3F(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public Point3F add(float value) {
        return this.add(value, value, value);
    }

    public Point3F add(float x, float y, float z) {
        return new Point3F(this.x + x, this.y + y, this.z + z);
    }

    public Point3F add(Point3F point) {
        return this.add(point.getX(), point.getY(), point.getZ());
    }

    public Point3F subtract(float value) {
        return this.subtract(value, value, value);
    }

    public Point3F subtract(float x, float y, float z) {
        return new Point3F(this.x - x, this.y - y, this.z - z);
    }

    public Point3F subtract(Point3F point) {
        return this.subtract(point.getX(), point.getY(), point.getZ());
    }

    public Point3F multiply(float value) {
        return this.multiply(value, value, value);
    }

    public Point3F multiply(float x, float y, float z) {
        return new Point3F(this.x * x, this.y * y, this.z * z);
    }

    public Point3F multiply(Point3F point) {
        return this.multiply(point.getX(), point.getY(), point.getZ());
    }

    public Point3F divide(float value) {
        return this.divide(value, value, value);
    }

    public Point3F divide(float x, float y, float z) {
        return new Point3F(this.x / x, this.y / y, this.z / z);
    }

    public Point3F divide(Point3F point) {
        return this.divide(point.getX(), point.getY(), point.getZ());
    }

    public double distanceSquared(float x, float y, float z) {
        return Math.pow(this.x - x, 2.0) + Math.pow(this.y - y, 2.0) + Math.pow(this.z - z, 2.0);
    }

    public double distanceSquared(Point3F point) {
        return this.distanceSquared(point.getX(), point.getY(), point.getZ());
    }

    public double distance(float x, float y, float z) {
        return Math.sqrt(this.distanceSquared(x, y, z));
    }

    public double distance(Point3F point) {
        return this.distance(point.getX(), point.getY(), point.getZ());
    }

    @Generated
    public String toString() {
        return "Point3F(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Point3F)) {
            return false;
        }
        Point3F other = (Point3F)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Float.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        return Float.compare(this.getZ(), other.getZ()) == 0;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Point3F;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getX());
        result = result * 59 + Float.floatToIntBits(this.getY());
        result = result * 59 + Float.floatToIntBits(this.getZ());
        return result;
    }
}

