/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.math.shapes.point;

import lombok.Generated;

public class Point3D {
    private final double x;
    private final double y;
    private final double z;

    public Point3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public Point3D add(double value) {
        return this.add(value, value, value);
    }

    public Point3D add(double x, double y, double z) {
        return new Point3D(this.x + x, this.y + y, this.z + z);
    }

    public Point3D add(Point3D point) {
        return this.add(point.getX(), point.getY(), point.getZ());
    }

    public Point3D subtract(double value) {
        return this.subtract(value, value, value);
    }

    public Point3D subtract(double x, double y, double z) {
        return new Point3D(this.x - x, this.y - y, this.z - z);
    }

    public Point3D subtract(Point3D point) {
        return this.subtract(point.getX(), point.getY(), point.getZ());
    }

    public Point3D multiply(double value) {
        return this.multiply(value, value, value);
    }

    public Point3D multiply(double x, double y, double z) {
        return new Point3D(this.x * x, this.y * y, this.z * z);
    }

    public Point3D multiply(Point3D point) {
        return this.multiply(point.getX(), point.getY(), point.getZ());
    }

    public Point3D divide(double value) {
        return this.divide(value, value, value);
    }

    public Point3D divide(double x, double y, double z) {
        return new Point3D(this.x / x, this.y / y, this.z / z);
    }

    public Point3D divide(Point3D point) {
        return this.divide(point.getX(), point.getY(), point.getZ());
    }

    public double distanceSquared(double x, double y, double z) {
        return Math.pow(this.x - x, 2.0) + Math.pow(this.y - y, 2.0) + Math.pow(this.z - z, 2.0);
    }

    public double distanceSquared(Point3D point) {
        return this.distanceSquared(point.getX(), point.getY(), point.getZ());
    }

    public double distance(double x, double y, double z) {
        return Math.sqrt(this.distanceSquared(x, y, z));
    }

    public double distance(Point3D point) {
        return this.distance(point.getX(), point.getY(), point.getZ());
    }

    @Generated
    public String toString() {
        return "Point3D(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Point3D)) {
            return false;
        }
        Point3D other = (Point3D)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        return Double.compare(this.getZ(), other.getZ()) == 0;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Point3D;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        return result;
    }
}

