/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.math.shapes.point;

import lombok.Generated;

public class Point2I {
    private final int x;
    private final int y;

    public Point2I(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Point2I add(int value) {
        return this.add(value, value);
    }

    public Point2I add(int x, int y) {
        return new Point2I(this.x + x, this.y + y);
    }

    public Point2I add(Point2I point) {
        return this.add(point.getX(), point.getY());
    }

    public Point2I subtract(int value) {
        return this.subtract(value, value);
    }

    public Point2I subtract(int x, int y) {
        return new Point2I(this.x - x, this.y - y);
    }

    public Point2I subtract(Point2I point) {
        return this.subtract(point.getX(), point.getY());
    }

    public Point2I multiply(int value) {
        return this.multiply(value, value);
    }

    public Point2I multiply(int x, int y) {
        return new Point2I(this.x * x, this.y * y);
    }

    public Point2I multiply(Point2I point) {
        return this.multiply(point.getX(), point.getY());
    }

    public Point2I divide(int value) {
        return this.divide(value, value);
    }

    public Point2I divide(int x, int y) {
        return new Point2I(this.x / x, this.y / y);
    }

    public Point2I divide(Point2I point) {
        return this.divide(point.getX(), point.getY());
    }

    public double distanceSquared(int x, int y) {
        return Math.pow(this.x - x, 2.0) + Math.pow(this.y - y, 2.0);
    }

    public double distanceSquared(Point2I point) {
        return this.distanceSquared(point.getX(), point.getY());
    }

    public double distance(int x, int y) {
        return Math.sqrt(this.distanceSquared(x, y));
    }

    public double distance(Point2I point) {
        return this.distance(point.getX(), point.getY());
    }

    @Generated
    public String toString() {
        return "Point2I(x=" + this.getX() + ", y=" + this.getY() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Point2I)) {
            return false;
        }
        Point2I other = (Point2I)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        return this.getY() == other.getY();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Point2I;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getY();
        return result;
    }
}

