/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.math.shapes.point;

import lombok.Generated;

public class Point2F {
    private final float x;
    private final float y;

    public Point2F(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public Point2F add(float value) {
        return this.add(value, value);
    }

    public Point2F add(float x, float y) {
        return new Point2F(this.x + x, this.y + y);
    }

    public Point2F add(Point2F point) {
        return this.add(point.getX(), point.getY());
    }

    public Point2F subtract(float value) {
        return this.subtract(value, value);
    }

    public Point2F subtract(float x, float y) {
        return new Point2F(this.x - x, this.y - y);
    }

    public Point2F subtract(Point2F point) {
        return this.subtract(point.getX(), point.getY());
    }

    public Point2F multiply(float value) {
        return this.multiply(value, value);
    }

    public Point2F multiply(float x, float y) {
        return new Point2F(this.x * x, this.y * y);
    }

    public Point2F multiply(Point2F point) {
        return this.multiply(point.getX(), point.getY());
    }

    public Point2F divide(float value) {
        return this.divide(value, value);
    }

    public Point2F divide(float x, float y) {
        return new Point2F(this.x / x, this.y / y);
    }

    public Point2F divide(Point2F point) {
        return this.divide(point.getX(), point.getY());
    }

    public double distanceSquared(float x, float y) {
        return Math.pow(this.x - x, 2.0) + Math.pow(this.y - y, 2.0);
    }

    public double distanceSquared(Point2F point) {
        return this.distanceSquared(point.getX(), point.getY());
    }

    public double distance(float x, float y) {
        return Math.sqrt(this.distanceSquared(x, y));
    }

    public double distance(Point2F point) {
        return this.distance(point.getX(), point.getY());
    }

    @Generated
    public String toString() {
        return "Point2F(x=" + this.getX() + ", y=" + this.getY() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Point2F)) {
            return false;
        }
        Point2F other = (Point2F)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        return Float.compare(this.getY(), other.getY()) == 0;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Point2F;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getX());
        result = result * 59 + Float.floatToIntBits(this.getY());
        return result;
    }
}

