/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.math.shapes.point;

import lombok.Generated;

public class Point2D {
    private final double x;
    private final double y;

    public Point2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public Point2D add(double value) {
        return this.add(value, value);
    }

    public Point2D add(double x, double y) {
        return new Point2D(this.x + x, this.y + y);
    }

    public Point2D add(Point2D point) {
        return this.add(point.getX(), point.getY());
    }

    public Point2D subtract(double value) {
        return this.subtract(value, value);
    }

    public Point2D subtract(double x, double y) {
        return new Point2D(this.x - x, this.y - y);
    }

    public Point2D subtract(Point2D point) {
        return this.subtract(point.getX(), point.getY());
    }

    public Point2D multiply(double value) {
        return this.multiply(value, value);
    }

    public Point2D multiply(double x, double y) {
        return new Point2D(this.x * x, this.y * y);
    }

    public Point2D multiply(Point2D point) {
        return this.multiply(point.getX(), point.getY());
    }

    public Point2D divide(double value) {
        return this.divide(value, value);
    }

    public Point2D divide(double x, double y) {
        return new Point2D(this.x / x, this.y / y);
    }

    public Point2D divide(Point2D point) {
        return this.divide(point.getX(), point.getY());
    }

    public double distanceSquared(double x, double y) {
        return Math.pow(this.x - x, 2.0) + Math.pow(this.y - y, 2.0);
    }

    public double distanceSquared(Point2D point) {
        return this.distanceSquared(point.getX(), point.getY());
    }

    public double distance(double x, double y) {
        return Math.sqrt(this.distanceSquared(x, y));
    }

    public double distance(Point2D point) {
        return this.distance(point.getX(), point.getY());
    }

    @Generated
    public String toString() {
        return "Point2D(x=" + this.getX() + ", y=" + this.getY() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Point2D)) {
            return false;
        }
        Point2D other = (Point2D)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        return Double.compare(this.getY(), other.getY()) == 0;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Point2D;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        return result;
    }
}

