/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.math;

import java.util.List;
import net.lenni0451.commons.math.MathUtils;

public class SliceCalculator<T> {
    private final List<T> list;
    private final int sliceSize;

    public SliceCalculator(List<T> list, int sliceSize) {
        this.list = list;
        this.sliceSize = sliceSize;
    }

    public List<T> getList() {
        return this.list;
    }

    public int getSliceCount() {
        return MathUtils.ceilInt((double)this.list.size() / (double)this.sliceSize);
    }

    public List<T> getSlice(int sliceIndex) {
        if (sliceIndex < 0 || sliceIndex >= this.getSliceCount()) {
            throw new IndexOutOfBoundsException();
        }
        int firstIndex = this.sliceSize * sliceIndex;
        return this.list.subList(firstIndex, Math.min(this.list.size(), firstIndex + this.sliceSize));
    }
}

