/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.math;

import lombok.Generated;

public final class MathUtils {
    private static final int DATA_BASE_UNIT = 1024;
    private static final String[] DATA_UNITS = new String[]{"KiB", "MiB", "GiB", "TiB", "PiB", "EiB"};

    public static int floorInt(float f) {
        return (int)Math.floor(f);
    }

    public static int floorInt(double d) {
        return (int)Math.floor(d);
    }

    public static long floorLong(float f) {
        return (long)Math.floor(f);
    }

    public static long floorLong(double d) {
        return (long)Math.floor(d);
    }

    public static int ceilInt(float f) {
        return (int)Math.ceil(f);
    }

    public static int ceilInt(double d) {
        return (int)Math.ceil(d);
    }

    public static long ceilLong(float f) {
        return (long)Math.ceil(f);
    }

    public static long ceilLong(double d) {
        return (long)Math.ceil(d);
    }

    public static int clamp(int i, int min, int max) {
        return Math.min(max, Math.max(min, i));
    }

    public static long clamp(long l, long min, long max) {
        return Math.min(max, Math.max(min, l));
    }

    public static float clamp(float f, float min, float max) {
        return Math.min(max, Math.max(min, f));
    }

    public static double clamp(double d, double min, double max) {
        return Math.min(max, Math.max(min, d));
    }

    public static boolean isDecimal(float f) {
        return f % 1.0f != 0.0f;
    }

    public static boolean isDecimal(double d) {
        return d % 1.0 != 0.0;
    }

    public static int map(int in, int inMin, int inMax, int outMin, int outMax) {
        return (in - inMin) * (outMax - outMin) / (inMax - inMin) + outMin;
    }

    public static long map(long in, long inMin, long inMax, long outMin, long outMax) {
        return (in - inMin) * (outMax - outMin) / (inMax - inMin) + outMin;
    }

    public static float map(float in, float inMin, float inMax, float outMin, float outMax) {
        return (in - inMin) * (outMax - outMin) / (inMax - inMin) + outMin;
    }

    public static double map(double in, double inMin, double inMax, double outMin, double outMax) {
        return (in - inMin) * (outMax - outMin) / (inMax - inMin) + outMin;
    }

    public static String formatBytes(long bytes) {
        boolean neg = bytes < 0L;
        if ((bytes = Math.abs(bytes)) < 1024L) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(1024.0));
        return (neg ? "-" : "") + String.format("%.1f ", (double)bytes / Math.pow(1024.0, exp)) + DATA_UNITS[exp - 1];
    }

    public static float round(float value, int precision) {
        int scale = (int)Math.pow(10.0, precision);
        return (float)Math.round(value * (float)scale) / (float)scale;
    }

    public static float[] round(float[] values, int precision) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = MathUtils.round(values[i], precision);
        }
        return values;
    }

    public static double round(double value, int precision) {
        int scale = (int)Math.pow(10.0, precision);
        return (double)Math.round(value * (double)scale) / (double)scale;
    }

    public static double[] round(double[] values, int precision) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = MathUtils.round(values[i], precision);
        }
        return values;
    }

    public static int alignPOT(int value, int alignment) {
        if (alignment <= 0) {
            throw new IllegalArgumentException("Alignment must be greater than 0");
        }
        return value + alignment - 1 & -alignment;
    }

    public static long alignPOT(long value, long alignment) {
        if (alignment <= 0L) {
            throw new IllegalArgumentException("Alignment must be greater than 0");
        }
        return value + alignment - 1L & -alignment;
    }

    public static int align(int value, int alignment) {
        if (alignment <= 0) {
            throw new IllegalArgumentException("Alignment must be greater than 0");
        }
        int remainder = value % alignment;
        if (remainder == 0) {
            return value;
        }
        return value + alignment - remainder;
    }

    public static long align(long value, long alignment) {
        if (alignment <= 0L) {
            throw new IllegalArgumentException("Alignment must be greater than 0");
        }
        long remainder = value % alignment;
        if (remainder == 0L) {
            return value;
        }
        return value + alignment - remainder;
    }

    public static int log(int value, int base) {
        if (value <= 0 || base <= 1) {
            throw new IllegalArgumentException("Value must be greater than 0 and base must be greater than 1");
        }
        return (int)(Math.log(value) / Math.log(base));
    }

    public static long log(long value, long base) {
        if (value <= 0L || base <= 1L) {
            throw new IllegalArgumentException("Value must be greater than 0 and base must be greater than 1");
        }
        return (long)(Math.log(value) / Math.log(base));
    }

    public static float log(float value, float base) {
        if (value <= 0.0f || base <= 1.0f) {
            throw new IllegalArgumentException("Value must be greater than 0 and base must be greater than 1");
        }
        return (float)(Math.log(value) / Math.log(base));
    }

    public static double log(double value, double base) {
        if (value <= 0.0 || base <= 1.0) {
            throw new IllegalArgumentException("Value must be greater than 0 and base must be greater than 1");
        }
        return Math.log(value) / Math.log(base);
    }

    @Generated
    private MathUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

