/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.lazy;

import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class Lazy<T> {
    protected final Object lock = new Object();
    private T value;
    private volatile boolean initialized = false;

    public static <T> Lazy<T> of(final Supplier<T> supplier) {
        return new Lazy<T>(){

            @Override
            protected T calculate() {
                return supplier.get();
            }
        };
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        if (!this.initialized) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.initialized) {
                    this.value = this.calculate();
                    this.initialized = true;
                }
            }
        }
        return this.value;
    }

    public void invalidate() {
        this.initialized = false;
    }

    protected abstract T calculate();
}

