/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.lazy;

import java.util.function.Supplier;
import net.lenni0451.commons.lazy.Lazy;

public abstract class ExpiringLazy<T>
extends Lazy<T> {
    private final ExpirationType expirationType;
    private final long expirationTime;
    private long lastAccessTime;

    public static <T> ExpiringLazy<T> of(ExpirationType expirationType, long expirationTime, final Supplier<T> supplier) {
        return new ExpiringLazy<T>(expirationType, expirationTime){

            @Override
            protected T calculate() {
                return supplier.get();
            }
        };
    }

    public ExpiringLazy(ExpirationType expirationType, long expirationTime) {
        this.expirationType = expirationType;
        this.expirationTime = expirationTime;
        this.lastAccessTime = System.currentTimeMillis();
    }

    public ExpirationType getExpirationType() {
        return this.expirationType;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.lastAccessTime > this.expirationTime;
    }

    @Override
    public T get() {
        if (this.isExpired()) {
            super.invalidate();
        }
        if (this.expirationType == ExpirationType.READ) {
            this.lastAccessTime = System.currentTimeMillis();
        } else if (this.expirationType == ExpirationType.WRITE && !super.isInitialized()) {
            this.lastAccessTime = System.currentTimeMillis();
        }
        return super.get();
    }

    public static enum ExpirationType {
        READ,
        WRITE;

    }
}

