/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.io.stream;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class SequentialInputStream
extends InputStream {
    private final Object lock = new Object();
    private byte[] available = new byte[0];
    private int pos = 0;
    private int limit = 0;
    private boolean closed = false;
    private Throwable error = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.lock;
        synchronized (object) {
            return this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException("Stream is closed");
            }
            if (this.pos > 0) {
                System.arraycopy(this.available, this.pos, this.available, 0, this.limit - this.pos);
                this.limit -= this.pos;
                this.pos = 0;
            }
            if (this.limit + bytes.length > this.available.length) {
                this.available = Arrays.copyOf(this.available, this.limit + bytes.length);
            }
            System.arraycopy(bytes, 0, this.available, this.limit, bytes.length);
            this.limit += bytes.length;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForData() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            while (this.pos >= this.limit && !this.closed) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Thread interrupted", e);
                }
            }
            if (this.error != null) {
                if (this.error instanceof IOException) {
                    throw (IOException)this.error;
                }
                throw new IOException("Error while reading stream", this.error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.waitForData();
            if (this.pos >= this.limit) {
                return -1;
            }
            return this.available[this.pos++] & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(@Nonnull byte[] b, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.waitForData();
            if (this.pos >= this.limit) {
                return -1;
            }
            int bytesToRead = Math.min(len, this.limit - this.pos);
            System.arraycopy(this.available, this.pos, b, off, bytesToRead);
            this.pos += bytesToRead;
            return bytesToRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.closed = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Throwable error) {
        Object object = this.lock;
        synchronized (object) {
            this.error = error;
            this.closed = true;
            this.lock.notifyAll();
        }
    }
}

