/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.annotation.WillNotClose;
import lombok.Generated;

public final class IOUtils {
    public static Optional<byte[]> readResource(String path) throws IOException {
        return IOUtils.readResource(IOUtils.class, path);
    }

    public static Optional<byte[]> readResource(Class<?> clazz, String path) throws IOException {
        try (InputStream is = clazz.getResourceAsStream(path);){
            if (is == null) {
                Optional<byte[]> optional = Optional.empty();
                return optional;
            }
            Optional<byte[]> optional = Optional.of(IOUtils.readAll(is));
            return optional;
        }
    }

    public static Optional<byte[]> readResource(ClassLoader loader, String path) throws IOException {
        try (InputStream is = loader.getResourceAsStream(path);){
            if (is == null) {
                Optional<byte[]> optional = Optional.empty();
                return optional;
            }
            Optional<byte[]> optional = Optional.of(IOUtils.readAll(is));
            return optional;
        }
    }

    @WillNotClose
    public static byte[] readAll(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = is.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
        return out.toByteArray();
    }

    @Generated
    private IOUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

