/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.WillNotClose;
import lombok.Generated;
import net.lenni0451.commons.io.IOUtils;
import org.jetbrains.annotations.ApiStatus;

public final class FileUtils {
    public static File create(String ... parts) {
        return new File(String.join((CharSequence)File.separator, parts));
    }

    public static File create(File file, String ... parts) {
        return new File(file, String.join((CharSequence)File.separator, parts));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<File> listFiles(File file) {
        if (!file.isDirectory()) {
            return Collections.emptyList();
        }
        try (Stream<Path> s = Files.walk(file.toPath(), FileVisitOption.FOLLOW_LINKS);){
            List<File> list = s.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).collect(Collectors.toList());
            return list;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<File> listFiles(File file, Predicate<File> filter) {
        if (!file.isDirectory()) {
            return Collections.emptyList();
        }
        try (Stream<Path> s = Files.walk(file.toPath(), FileVisitOption.FOLLOW_LINKS);){
            List<File> list = s.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).filter(filter).collect(Collectors.toList());
            return list;
        }
    }

    public static void deletePathTree(File file) {
        Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.TERMINATE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void recursiveDelete(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                FileUtils.recursiveDelete(f);
            }
        }
        file.delete();
    }

    @Deprecated
    @WillNotClose
    @ApiStatus.ScheduledForRemoval
    public static void read(File file, InputStream is) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(IOUtils.readAll(is));
        }
    }

    @Deprecated
    @WillNotClose
    @ApiStatus.ScheduledForRemoval
    public static void write(File file, OutputStream os) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            os.write(IOUtils.readAll(fis));
        }
    }

    @Generated
    private FileUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

