/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.lenni0451.commons.collections.Maps;

public class FileSystemZip
implements AutoCloseable {
    private final File file;
    private final FileSystem zipFileSystem;
    private final Path rootPath;

    public FileSystemZip(File file) throws IOException, URISyntaxException {
        this.file = file;
        this.zipFileSystem = FileSystems.newFileSystem(new URI("jar:" + file.toURI()), Maps.hashMap((Object[])new Object[]{"create", "true"}));
        this.rootPath = this.zipFileSystem.getRootDirectories().iterator().next();
    }

    public File getFile() {
        return this.file;
    }

    public Path getRootPath() {
        return this.rootPath;
    }

    public void addEntry(String name, @Nullable byte[] bytes) throws IOException {
        Path path = this.rootPath.resolve(name);
        if (bytes == null) {
            Files.createDirectories(path, new FileAttribute[0]);
        } else {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, bytes, new OpenOption[0]);
        }
    }

    public void addDirectory(String name) throws IOException {
        this.addEntry(name, null);
    }

    public Entry getEntry(String name) throws FileNotFoundException {
        Path path = this.rootPath.resolve(name);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("File not found: " + name);
        }
        return new Entry(path);
    }

    public boolean hasEntry(String name) {
        Path path = this.rootPath.resolve(name);
        return Files.exists(path, new LinkOption[0]);
    }

    public boolean hasFile(String name) {
        Path path = this.rootPath.resolve(name);
        return Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0]);
    }

    public boolean hasDirectory(String name) {
        Path path = this.rootPath.resolve(name);
        return Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]);
    }

    public void forEach(Consumer<Entry> consumer) throws IOException {
        try (Stream<Path> paths = Files.walk(this.rootPath, new FileVisitOption[0]);){
            paths.forEach((? super T path) -> consumer.accept(new Entry((Path)path)));
        }
    }

    @Override
    public void close() throws Exception {
        this.zipFileSystem.close();
    }

    public class Entry {
        private final Path path;

        private Entry(Path path) {
            this.path = path;
        }

        public Path getPath() {
            return this.path;
        }

        public String getRelativePath() {
            return FileSystemZip.this.rootPath.relativize(this.path).toString();
        }

        public String getName() {
            Path fileName = this.path.getFileName();
            if (fileName == null) {
                return "";
            }
            return fileName.toString();
        }

        public boolean exists() {
            return Files.exists(this.path, new LinkOption[0]);
        }

        public boolean isFile() {
            return !Files.isDirectory(this.path, new LinkOption[0]);
        }

        public boolean isDirectory() {
            return Files.isDirectory(this.path, new LinkOption[0]);
        }

        public void delete() throws IOException {
            if (this.isDirectory()) {
                Files.walkFileTree(this.path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            } else {
                Files.delete(this.path);
            }
        }

        public byte[] getData() throws IOException {
            if (this.isDirectory()) {
                throw new IllegalStateException("Entry is a directory");
            }
            return Files.readAllBytes(this.path);
        }

        public void setData(@Nullable byte[] bytes) throws IOException {
            if (bytes == null) {
                if (this.isFile()) {
                    throw new IllegalStateException("Entry is a file");
                }
                Files.createDirectories(this.path, new FileAttribute[0]);
            } else {
                if (this.isDirectory()) {
                    throw new IllegalStateException("Entry is a directory");
                }
                Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
                Files.write(this.path, bytes, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
        }
    }
}

