/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.annotation.WillNotClose;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;

public class AESEncryption {
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final int BUFFER_SIZE = 1024;
    private final Settings settings;

    public AESEncryption() {
        this(new Settings());
    }

    public AESEncryption(Settings settings) {
        this.settings = settings;
    }

    public byte[] encrypt(byte[] key, byte[] data) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeyException, IOException, IllegalBlockSizeException, BadPaddingException {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.encrypt(key, in, out);
        return out.toByteArray();
    }

    public void encrypt(byte[] key, @WillNotClose InputStream in, @WillNotClose OutputStream out) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeyException, IOException, IllegalBlockSizeException, BadPaddingException {
        int bytesRead;
        byte[] salt = new byte[this.settings.saltLength];
        RANDOM.nextBytes(salt);
        byte[] iv = new byte[this.settings.ivLength];
        RANDOM.nextBytes(iv);
        SecretKey secretKey = this.generateSecretKey(key, salt);
        Cipher cipher = Cipher.getInstance(this.settings.algorithm);
        cipher.init(1, (Key)secretKey, new IvParameterSpec(iv));
        out.write(salt);
        out.write(iv);
        byte[] buffer = new byte[1024];
        while ((bytesRead = in.read(buffer)) != -1) {
            byte[] output = cipher.update(buffer, 0, bytesRead);
            if (output == null) continue;
            out.write(output);
        }
        byte[] outputBytes = cipher.doFinal();
        if (outputBytes != null) {
            out.write(outputBytes);
        }
    }

    public byte[] decrypt(byte[] key, byte[] data) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.decrypt(key, in, out);
        return out.toByteArray();
    }

    public void decrypt(byte[] key, @WillNotClose InputStream in, @WillNotClose OutputStream out) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        int bytesRead;
        byte[] salt = this.readFully(in, this.settings.saltLength);
        byte[] iv = this.readFully(in, this.settings.ivLength);
        SecretKey secretKey = this.generateSecretKey(key, salt);
        Cipher cipher = Cipher.getInstance(this.settings.algorithm);
        cipher.init(2, (Key)secretKey, new IvParameterSpec(iv));
        byte[] buffer = new byte[1024];
        while ((bytesRead = in.read(buffer)) != -1) {
            byte[] output = cipher.update(buffer, 0, bytesRead);
            if (output == null) continue;
            out.write(output);
        }
        byte[] outputBytes = cipher.doFinal();
        if (outputBytes != null) {
            out.write(outputBytes);
        }
    }

    private SecretKey generateSecretKey(byte[] key, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance(this.settings.keyAlgorithm);
        char[] keyChars = new char[key.length];
        for (int i = 0; i < key.length; ++i) {
            keyChars[i] = (char)(key[i] & 0xFF);
        }
        PBEKeySpec spec = new PBEKeySpec(keyChars, salt, this.settings.iterations, this.settings.keyLength);
        SecretKey tmp = factory.generateSecret(spec);
        return new SecretKeySpec(tmp.getEncoded(), "AES");
    }

    private byte[] readFully(InputStream in, int length) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[length];
        for (int read = 0; read < length; read += bytesRead) {
            bytesRead = in.read(buffer, read, length - read);
            if (bytesRead != -1) continue;
            throw new IOException("Unexpected end of stream");
        }
        return buffer;
    }

    public static class Settings {
        private final String algorithm;
        private final String keyAlgorithm;
        private final int keyLength;
        private final int iterations;
        private final int saltLength;
        private final int ivLength;

        @Generated
        private static String $default$algorithm() {
            return "AES/CBC/PKCS5Padding";
        }

        @Generated
        private static String $default$keyAlgorithm() {
            return "PBKDF2WithHmacSHA1";
        }

        @Generated
        private static int $default$keyLength() {
            return 256;
        }

        @Generated
        private static int $default$iterations() {
            return Short.MAX_VALUE;
        }

        @Generated
        private static int $default$saltLength() {
            return 8;
        }

        @Generated
        private static int $default$ivLength() {
            return 16;
        }

        @Generated
        public static SettingsBuilder builder() {
            return new SettingsBuilder();
        }

        @Generated
        public Settings() {
            this.algorithm = Settings.$default$algorithm();
            this.keyAlgorithm = Settings.$default$keyAlgorithm();
            this.keyLength = Settings.$default$keyLength();
            this.iterations = Settings.$default$iterations();
            this.saltLength = Settings.$default$saltLength();
            this.ivLength = Settings.$default$ivLength();
        }

        @Generated
        public Settings(String algorithm, String keyAlgorithm, int keyLength, int iterations, int saltLength, int ivLength) {
            this.algorithm = algorithm;
            this.keyAlgorithm = keyAlgorithm;
            this.keyLength = keyLength;
            this.iterations = iterations;
            this.saltLength = saltLength;
            this.ivLength = ivLength;
        }

        @Generated
        public static class SettingsBuilder {
            @Generated
            private boolean algorithm$set;
            @Generated
            private String algorithm$value;
            @Generated
            private boolean keyAlgorithm$set;
            @Generated
            private String keyAlgorithm$value;
            @Generated
            private boolean keyLength$set;
            @Generated
            private int keyLength$value;
            @Generated
            private boolean iterations$set;
            @Generated
            private int iterations$value;
            @Generated
            private boolean saltLength$set;
            @Generated
            private int saltLength$value;
            @Generated
            private boolean ivLength$set;
            @Generated
            private int ivLength$value;

            @Generated
            SettingsBuilder() {
            }

            @Generated
            public SettingsBuilder algorithm(String algorithm) {
                this.algorithm$value = algorithm;
                this.algorithm$set = true;
                return this;
            }

            @Generated
            public SettingsBuilder keyAlgorithm(String keyAlgorithm) {
                this.keyAlgorithm$value = keyAlgorithm;
                this.keyAlgorithm$set = true;
                return this;
            }

            @Generated
            public SettingsBuilder keyLength(int keyLength) {
                this.keyLength$value = keyLength;
                this.keyLength$set = true;
                return this;
            }

            @Generated
            public SettingsBuilder iterations(int iterations) {
                this.iterations$value = iterations;
                this.iterations$set = true;
                return this;
            }

            @Generated
            public SettingsBuilder saltLength(int saltLength) {
                this.saltLength$value = saltLength;
                this.saltLength$set = true;
                return this;
            }

            @Generated
            public SettingsBuilder ivLength(int ivLength) {
                this.ivLength$value = ivLength;
                this.ivLength$set = true;
                return this;
            }

            @Generated
            public Settings build() {
                String algorithm$value = this.algorithm$value;
                if (!this.algorithm$set) {
                    algorithm$value = Settings.$default$algorithm();
                }
                String keyAlgorithm$value = this.keyAlgorithm$value;
                if (!this.keyAlgorithm$set) {
                    keyAlgorithm$value = Settings.$default$keyAlgorithm();
                }
                int keyLength$value = this.keyLength$value;
                if (!this.keyLength$set) {
                    keyLength$value = Settings.$default$keyLength();
                }
                int iterations$value = this.iterations$value;
                if (!this.iterations$set) {
                    iterations$value = Settings.$default$iterations();
                }
                int saltLength$value = this.saltLength$value;
                if (!this.saltLength$set) {
                    saltLength$value = Settings.$default$saltLength();
                }
                int ivLength$value = this.ivLength$value;
                if (!this.ivLength$set) {
                    ivLength$value = Settings.$default$ivLength();
                }
                return new Settings(algorithm$value, keyAlgorithm$value, keyLength$value, iterations$value, saltLength$value, ivLength$value);
            }

            @Generated
            public String toString() {
                return "AESEncryption.Settings.SettingsBuilder(algorithm$value=" + this.algorithm$value + ", keyAlgorithm$value=" + this.keyAlgorithm$value + ", keyLength$value=" + this.keyLength$value + ", iterations$value=" + this.iterations$value + ", saltLength$value=" + this.saltLength$value + ", ivLength$value=" + this.ivLength$value + ")";
            }
        }
    }
}

