/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.color;

import java.awt.Color;
import lombok.Generated;
import net.lenni0451.commons.math.MathUtils;

public final class ColorUtils {
    public static Color getRainbowColor(int offset, float divider) {
        long l = System.currentTimeMillis() + (long)offset;
        return Color.getHSBColor((float)(l %= (long)((int)(1000.0f * divider))) / divider / 1000.0f, 1.0f, 1.0f);
    }

    public static Color setRed(Color color, int r) {
        if (color.getRed() == r) {
            return color;
        }
        return new Color(MathUtils.clamp(r, 0, 255), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public static Color setGreen(Color color, int g) {
        if (color.getGreen() == g) {
            return color;
        }
        return new Color(color.getRed(), MathUtils.clamp(g, 0, 255), color.getBlue(), color.getAlpha());
    }

    public static Color setBlue(Color color, int b) {
        if (color.getBlue() == b) {
            return color;
        }
        return new Color(color.getRed(), color.getGreen(), MathUtils.clamp(b, 0, 255), color.getAlpha());
    }

    public static Color setAlpha(Color color, int a) {
        if (color.getAlpha() == a) {
            return color;
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), MathUtils.clamp(a, 0, 255));
    }

    public static Color invert(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue(), color.getAlpha());
    }

    public static Color multiply(Color color, float factor) {
        return ColorUtils.multiply(color, factor, factor, factor, 1.0f);
    }

    public static Color multiplyAlpha(Color color, float factor) {
        return ColorUtils.multiply(color, 1.0f, 1.0f, 1.0f, factor);
    }

    public static Color multiplyAll(Color color, float factor) {
        return ColorUtils.multiply(color, factor, factor, factor, factor);
    }

    public static Color multiply(Color color, float rFactor, float gFactor, float bFactor, float aFactor) {
        return new Color(MathUtils.clamp((int)((float)color.getRed() * rFactor), 0, 255), MathUtils.clamp((int)((float)color.getGreen() * gFactor), 0, 255), MathUtils.clamp((int)((float)color.getBlue() * bFactor), 0, 255), MathUtils.clamp((int)((float)color.getAlpha() * aFactor), 0, 255));
    }

    public static Color interpolate(float progress, Color color1, Color color2) {
        return new Color(MathUtils.clamp((int)((float)color1.getRed() + (float)(color2.getRed() - color1.getRed()) * progress), 0, 255), MathUtils.clamp((int)((float)color1.getGreen() + (float)(color2.getGreen() - color1.getGreen()) * progress), 0, 255), MathUtils.clamp((int)((float)color1.getBlue() + (float)(color2.getBlue() - color1.getBlue()) * progress), 0, 255), MathUtils.clamp((int)((float)color1.getAlpha() + (float)(color2.getAlpha() - color1.getAlpha()) * progress), 0, 255));
    }

    public static Color interpolate(float progress, Color[] colors, float[] steps) {
        if (colors.length != steps.length) {
            throw new IllegalArgumentException("Colors and steps must have the same length");
        }
        if (colors.length == 0) {
            throw new IllegalArgumentException("Colors and steps must have a length greater than 0");
        }
        if (colors.length == 1) {
            return colors[0];
        }
        if (progress <= steps[0]) {
            return colors[0];
        }
        if (progress >= steps[steps.length - 1]) {
            return colors[colors.length - 1];
        }
        for (int i = 0; i < steps.length; ++i) {
            if (!(progress < steps[i])) continue;
            float stepProgress = (progress - steps[i - 1]) / (steps[i] - steps[i - 1]);
            return ColorUtils.interpolate(stepProgress, colors[i - 1], colors[i]);
        }
        return colors[colors.length - 1];
    }

    public static Color interpolate(float progress, Color ... colors) {
        if (colors.length == 0) {
            throw new IllegalArgumentException("Colors must have a length greater than 0");
        }
        if (colors.length == 1) {
            return colors[0];
        }
        if (colors.length == 2) {
            return ColorUtils.interpolate(progress, colors[0], colors[1]);
        }
        float step = 1.0f / (float)(colors.length - 1);
        float[] steps = new float[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            steps[i] = step * (float)i;
        }
        return ColorUtils.interpolate(progress, colors, steps);
    }

    public static int distance(Color color1, Color color2) {
        return Math.abs(color1.getRed() - color2.getRed()) + Math.abs(color1.getGreen() - color2.getGreen()) + Math.abs(color1.getBlue() - color2.getBlue());
    }

    public static Color mix(Color color1, Color color2) {
        return new Color(color1.getRed() * color2.getRed() / 255, color1.getGreen() * color2.getGreen() / 255, color1.getBlue() * color2.getBlue() / 255, color1.getAlpha() * color2.getAlpha() / 255);
    }

    @Generated
    private ColorUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

