/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.color;

import java.awt.Color;

public class ColorConverter {
    public static final ColorConverter RGB = new ColorConverter(16, 8, 0);
    public static final ColorConverter ARGB = new ColorConverter(16, 8, 0, 24);
    public static final ColorConverter RGBA = new ColorConverter(24, 16, 8, 0);
    public static final ColorConverter BGR = new ColorConverter(0, 8, 16);
    public static final ColorConverter ABGR = new ColorConverter(0, 8, 16, 24);
    public static final ColorConverter BGRA = new ColorConverter(8, 16, 24, 0);
    private final int rShift;
    private final int gShift;
    private final int bShift;
    private final int aShift;

    public static int convert(int color, ColorConverter from, ColorConverter to) {
        int r = from.getRed(color);
        int g = from.getGreen(color);
        int b = from.getBlue(color);
        int a = from.getAlpha(color);
        return to.to(r, g, b, a);
    }

    public static float[] convert(float[] color, ColorConverter from, ColorConverter to) {
        float r = from.getRed(color);
        float g = from.getGreen(color);
        float b = from.getBlue(color);
        float a = from.getAlpha(color);
        return to.toFloats(r, g, b, a);
    }

    public static int convertToInt(float[] color, ColorConverter from, ColorConverter to) {
        float r = from.getRed(color);
        float g = from.getGreen(color);
        float b = from.getBlue(color);
        float a = from.getAlpha(color);
        return to.to(r, g, b, a);
    }

    public static float[] convertToFloats(int color, ColorConverter from, ColorConverter to) {
        int r = from.getRed(color);
        int g = from.getGreen(color);
        int b = from.getBlue(color);
        int a = from.getAlpha(color);
        return to.toFloats(r, g, b, a);
    }

    public ColorConverter(int rShift, int gShift, int bShift) {
        this(rShift, gShift, bShift, -1);
    }

    public ColorConverter(int rShift, int gShift, int bShift, int aShift) {
        this.rShift = rShift;
        this.gShift = gShift;
        this.bShift = bShift;
        this.aShift = aShift;
    }

    public int getRed(int color) {
        return color >> this.rShift & 0xFF;
    }

    public float getRed(float[] color) {
        return color[color.length - 1 - this.rShift / 8];
    }

    public int setRed(int color, int r) {
        color &= ~(255 << this.rShift);
        return color |= (r & 0xFF) << this.rShift;
    }

    public float[] setRed(float[] color, float r) {
        color[color.length - 1 - this.rShift / 8] = r;
        return color;
    }

    public int getGreen(int color) {
        return color >> this.gShift & 0xFF;
    }

    public float getGreen(float[] color) {
        return color[color.length - 1 - this.gShift / 8];
    }

    public int setGreen(int color, int g) {
        color &= ~(255 << this.gShift);
        return color |= (g & 0xFF) << this.gShift;
    }

    public float[] setGreen(float[] color, float g) {
        color[color.length - 1 - this.gShift / 8] = g;
        return color;
    }

    public int getBlue(int color) {
        return color >> this.bShift & 0xFF;
    }

    public float getBlue(float[] color) {
        return color[color.length - 1 - this.bShift / 8];
    }

    public int setBlue(int color, int b) {
        color &= ~(255 << this.bShift);
        return color |= (b & 0xFF) << this.bShift;
    }

    public float[] setBlue(float[] color, float b) {
        color[color.length - 1 - this.bShift / 8] = b;
        return color;
    }

    public int getAlpha(int color) {
        if (this.aShift == -1) {
            return 255;
        }
        return color >> this.aShift & 0xFF;
    }

    public float getAlpha(float[] color) {
        if (this.aShift == -1) {
            return 1.0f;
        }
        return color[color.length - 1 - this.aShift / 8];
    }

    public int setAlpha(int color, int a) {
        if (this.aShift == -1) {
            return color;
        }
        color &= ~(255 << this.aShift);
        return color |= (a & 0xFF) << this.aShift;
    }

    public float[] setAlpha(float[] color, float a) {
        if (this.aShift == -1) {
            return color;
        }
        color[color.length - 1 - this.aShift / 8] = a;
        return color;
    }

    public int to(Color color) {
        return this.to(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public int to(int r, int g, int b, int a) {
        return r << this.rShift | g << this.gShift | b << this.bShift | (this.aShift == -1 ? 0 : a << this.aShift);
    }

    public int to(float r, float g, float b, float a) {
        return (int)(r * 255.0f) << this.rShift | (int)(g * 255.0f) << this.gShift | (int)(b * 255.0f) << this.bShift | (this.aShift == -1 ? 0 : (int)(a * 255.0f) << this.aShift);
    }

    public float[] toFloats(Color color) {
        return this.toFloats(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public float[] toFloats(int r, int g, int b) {
        return this.toFloats(r, g, b, 255);
    }

    public float[] toFloats(int r, int g, int b, int a) {
        float[] floats = new float[this.aShift == -1 ? 3 : 4];
        int arrayOffset = floats.length - 1;
        floats[arrayOffset - this.rShift / 8] = (float)r / 255.0f;
        floats[arrayOffset - this.gShift / 8] = (float)g / 255.0f;
        floats[arrayOffset - this.bShift / 8] = (float)b / 255.0f;
        if (this.aShift != -1) {
            floats[arrayOffset - this.aShift / 8] = (float)a / 255.0f;
        }
        return floats;
    }

    public float[] toFloats(float r, float g, float b, float a) {
        float[] floats = new float[this.aShift == -1 ? 3 : 4];
        int arrayOffset = floats.length - 1;
        floats[arrayOffset - this.rShift / 8] = r;
        floats[arrayOffset - this.gShift / 8] = g;
        floats[arrayOffset - this.bShift / 8] = b;
        if (this.aShift != -1) {
            floats[arrayOffset - this.aShift / 8] = a;
        }
        return floats;
    }

    public Color from(int color) {
        return new Color(color >> this.rShift & 0xFF, color >> this.gShift & 0xFF, color >> this.bShift & 0xFF, this.aShift == -1 ? 255 : color >> this.aShift & 0xFF);
    }

    public Color from(float[] color) {
        if (color.length == 3 && this.aShift != -1) {
            throw new IllegalArgumentException("Color format has no alpha value");
        }
        if (color.length == 4 && this.aShift == -1) {
            throw new IllegalArgumentException("Color format has an alpha value");
        }
        if (color.length != 3 && color.length != 4) {
            throw new IllegalArgumentException("Color format has an invalid length");
        }
        int arrayOffset = color.length - 1;
        return new Color(color[arrayOffset - this.rShift / 8], color[arrayOffset - this.gShift / 8], color[arrayOffset - this.bShift / 8], this.aShift == -1 ? 1.0f : color[arrayOffset - this.aShift / 8]);
    }

    public Color from(float r, float g, float b) {
        return this.from(r, g, b, 1.0f);
    }

    public Color from(float r, float g, float b, float a) {
        return new Color(r, g, b, a);
    }
}

