/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.color;

import java.util.Objects;
import net.lenni0451.commons.math.MathUtils;

public class Color {
    public static final Color TRANSPARENT = Color.fromRGBA(0, 0, 0, 0);
    public static final Color BLACK = Color.fromRGB(0, 0, 0);
    public static final Color LIGHT_GRAY = Color.fromRGB(192, 192, 192);
    public static final Color GRAY = Color.fromRGB(128, 128, 128);
    public static final Color DARK_GRAY = Color.fromRGB(64, 64, 64);
    public static final Color WHITE = Color.fromRGB(255, 255, 255);
    public static final Color RED = Color.fromRGB(255, 0, 0);
    public static final Color GREEN = Color.fromRGB(0, 255, 0);
    public static final Color BLUE = Color.fromRGB(0, 0, 255);
    public static final Color ORANGE = Color.fromRGB(255, 200, 0);
    public static final Color YELLOW = Color.fromRGB(255, 255, 0);
    public static final Color CYAN = Color.fromRGB(0, 255, 255);
    public static final Color PINK = Color.fromRGB(255, 175, 175);
    public static final Color MAGENTA = Color.fromRGB(255, 0, 255);
    private final byte r;
    private final byte g;
    private final byte b;
    private final byte a;

    public static Color fromRGB(int rgb) {
        return Color.fromRGB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    public static Color fromBGR(int bgr) {
        return Color.fromRGB(bgr & 0xFF, bgr >> 8 & 0xFF, bgr >> 16 & 0xFF);
    }

    public static Color fromRGB(int r, int g, int b) {
        return Color.fromRGBA(r, g, b, 255);
    }

    public static Color fromRGBA(int rgba) {
        return Color.fromRGBA(rgba >> 24 & 0xFF, rgba >> 16 & 0xFF, rgba >> 8 & 0xFF, rgba & 0xFF);
    }

    public static Color fromARGB(int argb) {
        return Color.fromRGBA(argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF, argb >> 24 & 0xFF);
    }

    public static Color fromBGRA(int bgra) {
        return Color.fromRGBA(bgra >> 8 & 0xFF, bgra >> 16 & 0xFF, bgra >> 24 & 0xFF, bgra & 0xFF);
    }

    public static Color fromABGR(int abgr) {
        return Color.fromRGBA(abgr & 0xFF, abgr >> 8 & 0xFF, abgr >> 16 & 0xFF, abgr >> 24 & 0xFF);
    }

    public static Color fromRGBA(int r, int g, int b, int a) {
        Color.verify(r, g, b, a);
        return Color.directRGBA(r, g, b, a);
    }

    public static Color directRGBA(int r, int g, int b, int a) {
        return new Color((byte)(r & 0xFF), (byte)(g & 0xFF), (byte)(b & 0xFF), (byte)(a & 0xFF));
    }

    public static Color fromRGBF(float[] rgb) {
        return Color.fromRGBF(rgb[0], rgb[1], rgb[2]);
    }

    public static Color fromBGRF(float[] bgr) {
        return Color.fromRGBF(bgr[2], bgr[1], bgr[0]);
    }

    public static Color fromRGBF(float r, float g, float b) {
        return Color.fromRGBAF(r, g, b, 1.0f);
    }

    public static Color fromRGBAF(float[] rgba) {
        return Color.fromRGBAF(rgba[0], rgba[1], rgba[2], rgba[3]);
    }

    public static Color fromARGBF(float[] argb) {
        return Color.fromRGBAF(argb[1], argb[2], argb[3], argb[0]);
    }

    public static Color fromBGRAF(float[] bgra) {
        return Color.fromRGBAF(bgra[2], bgra[1], bgra[0], bgra[3]);
    }

    public static Color fromABGRF(float[] abgr) {
        return Color.fromRGBAF(abgr[3], abgr[2], abgr[1], abgr[0]);
    }

    public static Color fromRGBAF(float r, float g, float b, float a) {
        Color.verify(r, g, b, a);
        return Color.directRGBA((int)(r * 255.0f) & 0xFF, (int)(g * 255.0f) & 0xFF, (int)(b * 255.0f) & 0xFF, (int)(a * 255.0f) & 0xFF);
    }

    public static Color fromHSB(float[] hsb) {
        return Color.fromHSB(hsb[0], hsb[1], hsb[2]);
    }

    public static Color fromHSB(float hue, float saturation, float brightness) {
        float b;
        float g;
        float r;
        if (saturation == 0.0f) {
            return Color.fromRGBF(brightness, brightness, brightness);
        }
        float h = (float)(((double)hue - Math.floor(hue)) * 6.0);
        float f = h - (float)Math.floor(h);
        float p = brightness * (1.0f - saturation);
        float q = brightness * (1.0f - saturation * f);
        float t = brightness * (1.0f - saturation * (1.0f - f));
        switch ((int)h) {
            case 0: {
                r = brightness;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = brightness;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = brightness;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = brightness;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = brightness;
                break;
            }
            case 5: {
                r = brightness;
                g = p;
                b = q;
                break;
            }
            default: {
                throw new IllegalStateException("Unable to convert HSB to RGB. Input:" + hue + ", " + saturation + ", " + brightness);
            }
        }
        return Color.fromRGBF(r, g, b);
    }

    public static Color fromAWT(java.awt.Color color) {
        return Color.fromARGB(color.getRGB());
    }

    public static Color getRainbowColor(int offset, float divider) {
        long l = System.currentTimeMillis() + (long)offset;
        return Color.fromHSB((float)(l %= (long)((int)(1000.0f * divider))) / divider / 1000.0f, 1.0f, 1.0f);
    }

    public static Color interpolate(float progress, Color color1, Color color2) {
        return Color.directRGBA(MathUtils.clamp((int)((float)color1.getRed() + (float)(color2.getRed() - color1.getRed()) * progress), 0, 255), MathUtils.clamp((int)((float)color1.getGreen() + (float)(color2.getGreen() - color1.getGreen()) * progress), 0, 255), MathUtils.clamp((int)((float)color1.getBlue() + (float)(color2.getBlue() - color1.getBlue()) * progress), 0, 255), MathUtils.clamp((int)((float)color1.getAlpha() + (float)(color2.getAlpha() - color1.getAlpha()) * progress), 0, 255));
    }

    public static Color interpolate(float progress, Color[] colors, float[] steps) {
        if (colors.length != steps.length) {
            throw new IllegalArgumentException("Colors and steps must have the same length");
        }
        if (colors.length == 0) {
            throw new IllegalArgumentException("Colors and steps must have a length greater than 0");
        }
        if (colors.length == 1) {
            return colors[0];
        }
        if (progress <= steps[0]) {
            return colors[0];
        }
        if (progress >= steps[steps.length - 1]) {
            return colors[colors.length - 1];
        }
        for (int i = 0; i < steps.length; ++i) {
            if (!(progress < steps[i])) continue;
            float stepProgress = (progress - steps[i - 1]) / (steps[i] - steps[i - 1]);
            return Color.interpolate(stepProgress, colors[i - 1], colors[i]);
        }
        return colors[colors.length - 1];
    }

    public static Color interpolate(float progress, Color ... colors) {
        if (colors.length == 0) {
            throw new IllegalArgumentException("Colors must have a length greater than 0");
        }
        if (colors.length == 1) {
            return colors[0];
        }
        if (colors.length == 2) {
            return Color.interpolate(progress, colors[0], colors[1]);
        }
        float step = 1.0f / (float)(colors.length - 1);
        float[] steps = new float[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            steps[i] = step * (float)i;
        }
        return Color.interpolate(progress, colors, steps);
    }

    private Color(byte r, byte g, byte b, byte a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public int getRed() {
        return this.r & 0xFF;
    }

    public float getRedF() {
        return (float)(this.r & 0xFF) / 255.0f;
    }

    public Color withRed(int r) {
        if (r == this.r) {
            return this;
        }
        Color.verify(r, "Red");
        return new Color((byte)(r & 0xFF), this.g, this.b, this.a);
    }

    public Color withRedF(float r) {
        Color.verify(r, "Red");
        return this.withRed((int)(r * 255.0f));
    }

    public int getGreen() {
        return this.g & 0xFF;
    }

    public float getGreenF() {
        return (float)(this.g & 0xFF) / 255.0f;
    }

    public Color withGreen(int g) {
        if (g == this.g) {
            return this;
        }
        Color.verify(g, "Green");
        return new Color(this.r, (byte)(g & 0xFF), this.b, this.a);
    }

    public Color withGreenF(float g) {
        Color.verify(g, "Green");
        return this.withGreen((int)(g * 255.0f));
    }

    public int getBlue() {
        return this.b & 0xFF;
    }

    public float getBlueF() {
        return (float)(this.b & 0xFF) / 255.0f;
    }

    public Color withBlue(int b) {
        if (b == this.b) {
            return this;
        }
        Color.verify(b, "Blue");
        return new Color(this.r, this.g, (byte)(b & 0xFF), this.a);
    }

    public Color withBlueF(float b) {
        Color.verify(b, "Blue");
        return this.withBlue((int)(b * 255.0f));
    }

    public int getAlpha() {
        return this.a & 0xFF;
    }

    public float getAlphaF() {
        return (float)(this.a & 0xFF) / 255.0f;
    }

    public Color withAlpha(int a) {
        if (a == this.a) {
            return this;
        }
        Color.verify(a, "Alpha");
        return new Color(this.r, this.g, this.b, (byte)(a & 0xFF));
    }

    public Color withAlphaF(float a) {
        Color.verify(a, "Alpha");
        return this.withAlpha((int)(a * 255.0f));
    }

    public int toRGB() {
        return (this.r & 0xFF) << 16 | (this.g & 0xFF) << 8 | this.b & 0xFF;
    }

    public int toBGR() {
        return (this.b & 0xFF) << 16 | (this.g & 0xFF) << 8 | this.r & 0xFF;
    }

    public int toRGBA() {
        return (this.r & 0xFF) << 24 | (this.g & 0xFF) << 16 | (this.b & 0xFF) << 8 | this.a & 0xFF;
    }

    public int toARGB() {
        return (this.a & 0xFF) << 24 | (this.r & 0xFF) << 16 | (this.g & 0xFF) << 8 | this.b & 0xFF;
    }

    public int toBGRA() {
        return (this.b & 0xFF) << 24 | (this.g & 0xFF) << 16 | (this.r & 0xFF) << 8 | this.a & 0xFF;
    }

    public int toABGR() {
        return (this.a & 0xFF) << 24 | (this.b & 0xFF) << 16 | (this.g & 0xFF) << 8 | this.r & 0xFF;
    }

    public float[] toRGBF() {
        return new float[]{this.getRedF(), this.getGreenF(), this.getBlueF()};
    }

    public float[] toBGRF() {
        return new float[]{this.getBlueF(), this.getGreenF(), this.getRedF()};
    }

    public float[] toRGBAF() {
        return new float[]{this.getRedF(), this.getGreenF(), this.getBlueF(), this.getAlphaF()};
    }

    public float[] toARGBF() {
        return new float[]{this.getAlphaF(), this.getRedF(), this.getGreenF(), this.getBlueF()};
    }

    public float[] toBGRAF() {
        return new float[]{this.getBlueF(), this.getGreenF(), this.getRedF(), this.getAlphaF()};
    }

    public float[] toABGRF() {
        return new float[]{this.getAlphaF(), this.getBlueF(), this.getGreenF(), this.getRedF()};
    }

    public float[] toHSB() {
        float s;
        float h;
        float r = this.getRedF();
        float g = this.getGreenF();
        float b = this.getBlueF();
        float max = Math.max(r, Math.max(g, b));
        float min = Math.min(r, Math.min(g, b));
        float delta = max - min;
        float v = max;
        if (max == 0.0f) {
            h = 0.0f;
            s = 0.0f;
        } else {
            s = delta / max;
            h = r == max ? (g - b) / delta : (g == max ? 2.0f + (b - r) / delta : 4.0f + (r - g) / delta);
        }
        h /= 6.0f;
        if (h < 0.0f) {
            h += 1.0f;
        }
        return new float[]{h, s, v};
    }

    public java.awt.Color toAWT() {
        return new java.awt.Color(this.toARGB(), true);
    }

    public Color brighter() {
        return this.brighter(0.7f);
    }

    public Color brighter(float factor) {
        int r = this.getRed();
        int g = this.getGreen();
        int b = this.getBlue();
        int a = this.getAlpha();
        int gray = (int)(1.0 / (1.0 - (double)factor));
        if (r == 0 && g == 0 && b == 0) {
            return Color.directRGBA(gray, gray, gray, a);
        }
        if (r > 0 && r < gray) {
            r = gray;
        }
        if (g > 0 && g < gray) {
            g = gray;
        }
        if (b > 0 && b < gray) {
            b = gray;
        }
        return Color.directRGBA(MathUtils.clamp((int)((float)r / factor), 0, 255), MathUtils.clamp((int)((float)g / factor), 0, 255), MathUtils.clamp((int)((float)b / factor), 0, 255), a);
    }

    public Color darker() {
        return this.darker(0.7f);
    }

    public Color darker(float factor) {
        return Color.directRGBA(MathUtils.clamp((int)((float)this.getRed() * factor), 0, 255), MathUtils.clamp((int)((float)this.getGreen() * factor), 0, 255), MathUtils.clamp((int)((float)this.getBlue() * factor), 0, 255), this.getAlpha());
    }

    public Color invert() {
        return Color.directRGBA(255 - this.getRed(), 255 - this.getGreen(), 255 - this.getBlue(), this.getAlpha());
    }

    public Color multiply(float multiplier) {
        return Color.directRGBA(MathUtils.clamp((int)((float)this.getRed() * multiplier), 0, 255), MathUtils.clamp((int)((float)this.getGreen() * multiplier), 0, 255), MathUtils.clamp((int)((float)this.getBlue() * multiplier), 0, 255), this.getAlpha());
    }

    public Color multiplyAlpha(float multiplier) {
        return Color.directRGBA(this.getRed(), this.getGreen(), this.getBlue(), MathUtils.clamp((int)((float)this.getAlpha() * multiplier), 0, 255));
    }

    public Color multiplyAll(float multiplier) {
        return Color.directRGBA(MathUtils.clamp((int)((float)this.getRed() * multiplier), 0, 255), MathUtils.clamp((int)((float)this.getGreen() * multiplier), 0, 255), MathUtils.clamp((int)((float)this.getBlue() * multiplier), 0, 255), MathUtils.clamp((int)((float)this.getAlpha() * multiplier), 0, 255));
    }

    public Color multiply(Color color) {
        return Color.directRGBA(MathUtils.clamp((int)((float)this.getRed() * color.getRedF()), 0, 255), MathUtils.clamp((int)((float)this.getGreen() * color.getGreenF()), 0, 255), MathUtils.clamp((int)((float)this.getBlue() * color.getBlueF()), 0, 255), MathUtils.clamp((int)((float)this.getAlpha() * color.getAlphaF()), 0, 255));
    }

    public int distance(Color color) {
        return Math.abs(this.getRed() - color.getRed()) + Math.abs(this.getGreen() - color.getGreen()) + Math.abs(this.getBlue() - color.getBlue());
    }

    private static void verify(int i, String channel) {
        if (i < 0 || i > 255) {
            throw new IllegalArgumentException(channel + " value must be between 0 and 255");
        }
    }

    private static void verify(int r, int g, int b, int a) {
        if (r < 0 || r > 255) {
            throw new IllegalArgumentException("Red value must be between 0 and 255");
        }
        if (g < 0 || g > 255) {
            throw new IllegalArgumentException("Green value must be between 0 and 255");
        }
        if (b < 0 || b > 255) {
            throw new IllegalArgumentException("Blue value must be between 0 and 255");
        }
        if (a < 0 || a > 255) {
            throw new IllegalArgumentException("Alpha value must be between 0 and 255");
        }
    }

    private static void verify(float f, String channel) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException(channel + " value must be between 0 and 1");
        }
    }

    private static void verify(float r, float g, float b, float a) {
        if (r < 0.0f || r > 1.0f) {
            throw new IllegalArgumentException("Red value must be between 0 and 1");
        }
        if (g < 0.0f || g > 1.0f) {
            throw new IllegalArgumentException("Green value must be between 0 and 1");
        }
        if (b < 0.0f || b > 1.0f) {
            throw new IllegalArgumentException("Blue value must be between 0 and 1");
        }
        if (a < 0.0f || a > 1.0f) {
            throw new IllegalArgumentException("Alpha value must be between 0 and 1");
        }
    }

    public String toString() {
        return "Color{r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", a=" + this.a + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Color color = (Color)o;
        return this.r == color.r && this.g == color.g && this.b == color.b && this.a == color.a;
    }

    public int hashCode() {
        return Objects.hash(this.r, this.g, this.b, this.a);
    }
}

