/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.arrays.wrapper;

import java.util.Arrays;
import net.lenni0451.commons.arrays.wrapper.ArrayWrapper;
import net.lenni0451.commons.math.NumberChecker;

public class StringArrayWrapper
extends ArrayWrapper<String> {
    public StringArrayWrapper(String[] array) {
        super(array);
    }

    public StringArrayWrapper wrappedSlice(int start) {
        return new StringArrayWrapper((String[])this.slice(start));
    }

    public StringArrayWrapper wrappedSlice(int start, int end) {
        return new StringArrayWrapper((String[])this.slice(start, end));
    }

    @Override
    public boolean isBoolean(int index) {
        if (!this.contains(index)) {
            return false;
        }
        try {
            Boolean.parseBoolean((String)this.get(index));
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @Override
    public boolean isByte(int index) {
        if (!this.contains(index)) {
            return false;
        }
        return NumberChecker.isByte((String)this.get(index));
    }

    @Override
    public boolean isShort(int index) {
        if (!this.contains(index)) {
            return false;
        }
        return NumberChecker.isShort((String)this.get(index));
    }

    @Override
    public boolean isChar(int index) {
        if (!this.contains(index)) {
            return false;
        }
        return ((String)this.get(index)).length() == 1;
    }

    @Override
    public boolean isInt(int index) {
        if (!this.contains(index)) {
            return false;
        }
        return NumberChecker.isInteger((String)this.get(index));
    }

    @Override
    public boolean isLong(int index) {
        if (!this.contains(index)) {
            return false;
        }
        return NumberChecker.isLong((String)this.get(index));
    }

    @Override
    public boolean isFloat(int index) {
        if (!this.contains(index)) {
            return false;
        }
        return NumberChecker.isFloat((String)this.get(index));
    }

    @Override
    public boolean isDouble(int index) {
        if (!this.contains(index)) {
            return false;
        }
        return NumberChecker.isDouble((String)this.get(index));
    }

    @Override
    public boolean getBoolean(int index, boolean def) {
        if (!this.isBoolean(index)) {
            return def;
        }
        return Boolean.parseBoolean((String)this.get(index));
    }

    @Override
    public byte getByte(int index, byte def) {
        if (!this.isByte(index)) {
            return def;
        }
        return Byte.parseByte((String)this.get(index));
    }

    @Override
    public short getShort(int index, short def) {
        if (!this.isShort(index)) {
            return def;
        }
        return Short.parseShort((String)this.get(index));
    }

    @Override
    public char getChar(int index, char def) {
        if (!this.isChar(index)) {
            return def;
        }
        return ((String)this.get(index)).charAt(0);
    }

    @Override
    public int getInt(int index, int def) {
        if (!this.isInt(index)) {
            return def;
        }
        return Integer.parseInt((String)this.get(index));
    }

    @Override
    public long getLong(int index, long def) {
        if (!this.isLong(index)) {
            return def;
        }
        return Long.parseLong((String)this.get(index));
    }

    @Override
    public float getFloat(int index, float def) {
        if (!this.isFloat(index)) {
            return def;
        }
        return Float.parseFloat((String)this.get(index));
    }

    @Override
    public double getDouble(int index, double def) {
        if (!this.isDouble(index)) {
            return def;
        }
        return Double.parseDouble((String)this.get(index));
    }

    public String join(String separator) {
        return String.join((CharSequence)separator, (CharSequence[])this.getArray());
    }

    public String join(String separator, int start) {
        return String.join((CharSequence)separator, (CharSequence[])Arrays.copyOfRange(this.getArray(), start, this.length()));
    }

    public String join(String separator, int start, int end) {
        return String.join((CharSequence)separator, (CharSequence[])Arrays.copyOfRange(this.getArray(), start, end));
    }
}

