/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.arrays.wrapper;

import net.lenni0451.commons.arrays.wrapper.ArrayWrapper;

public class ObjectArrayWrapper
extends ArrayWrapper<Object> {
    public ObjectArrayWrapper(Object[] array) {
        super(array);
    }

    public ObjectArrayWrapper wrappedSlice(int start) {
        return new ObjectArrayWrapper((Object[])this.slice(start));
    }

    public ObjectArrayWrapper wrappedSlice(int start, int end) {
        return new ObjectArrayWrapper((Object[])this.slice(start, end));
    }

    @Override
    public boolean isBoolean(int index) {
        if (!this.contains(index)) {
            return false;
        }
        return this.get(index) instanceof Boolean;
    }

    @Override
    public boolean isByte(int index) {
        if (!this.contains(index)) {
            return false;
        }
        return this.get(index) instanceof Byte;
    }

    @Override
    public boolean isShort(int index) {
        if (!this.contains(index)) {
            return false;
        }
        return this.get(index) instanceof Short;
    }

    @Override
    public boolean isChar(int index) {
        if (!this.contains(index)) {
            return false;
        }
        return this.get(index) instanceof Character;
    }

    @Override
    public boolean isInt(int index) {
        if (!this.contains(index)) {
            return false;
        }
        return this.get(index) instanceof Integer;
    }

    @Override
    public boolean isLong(int index) {
        if (!this.contains(index)) {
            return false;
        }
        return this.get(index) instanceof Long;
    }

    @Override
    public boolean isFloat(int index) {
        if (!this.contains(index)) {
            return false;
        }
        return this.get(index) instanceof Float;
    }

    @Override
    public boolean isDouble(int index) {
        if (!this.contains(index)) {
            return false;
        }
        return this.get(index) instanceof Double;
    }

    @Override
    public boolean getBoolean(int index, boolean def) {
        if (!this.isBoolean(index)) {
            return def;
        }
        return (Boolean)this.get(index);
    }

    @Override
    public byte getByte(int index, byte def) {
        if (!this.isByte(index)) {
            return def;
        }
        return (Byte)this.get(index);
    }

    @Override
    public short getShort(int index, short def) {
        if (!this.isShort(index)) {
            return def;
        }
        return (Short)this.get(index);
    }

    @Override
    public char getChar(int index, char def) {
        if (!this.isChar(index)) {
            return def;
        }
        return ((Character)this.get(index)).charValue();
    }

    @Override
    public int getInt(int index, int def) {
        if (!this.isInt(index)) {
            return def;
        }
        return (Integer)this.get(index);
    }

    @Override
    public long getLong(int index, long def) {
        if (!this.isLong(index)) {
            return def;
        }
        return (Long)this.get(index);
    }

    @Override
    public float getFloat(int index, float def) {
        if (!this.isFloat(index)) {
            return def;
        }
        return ((Float)this.get(index)).floatValue();
    }

    @Override
    public double getDouble(int index, double def) {
        if (!this.isDouble(index)) {
            return def;
        }
        return (Double)this.get(index);
    }
}

