/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.arrays.wrapper;

import java.util.Arrays;
import net.lenni0451.commons.arrays.ArrayUtils;

public abstract class ArrayWrapper<T> {
    private T[] array;

    public ArrayWrapper(T[] array) {
        this.array = array;
    }

    public T[] getArray() {
        return this.array;
    }

    public int length() {
        return this.array.length;
    }

    public boolean isEmpty() {
        return this.array.length == 0;
    }

    public boolean isNotEmpty() {
        return this.array.length != 0;
    }

    public boolean contains(int index) {
        return index >= 0 && index < this.array.length;
    }

    public boolean contains(T value) {
        return ArrayUtils.indexOf(this.array, value) != -1;
    }

    public T get(int index) {
        return this.array[index];
    }

    public T get(int index, T def) {
        return this.contains(index) ? this.array[index] : def;
    }

    public void set(int index, T value) {
        this.array[index] = value;
    }

    public void add(T value) {
        this.array = ArrayUtils.add(this.array, value);
    }

    @SafeVarargs
    public final void addAll(T ... values) {
        this.array = ArrayUtils.add(this.array, values);
    }

    public void addAll(ArrayWrapper<T> values) {
        this.addAll(values.getArray());
    }

    public void remove(int index) {
        this.array = ArrayUtils.removeAt(this.array, index);
    }

    public void remove(T value) {
        this.array = ArrayUtils.remove(this.array, value);
    }

    public T[] slice(int start) {
        return this.slice(start, this.array.length);
    }

    public T[] slice(int start, int end) {
        return Arrays.copyOfRange(this.array, start, end);
    }

    public abstract boolean isBoolean(int var1);

    public abstract boolean isByte(int var1);

    public abstract boolean isShort(int var1);

    public abstract boolean isChar(int var1);

    public abstract boolean isInt(int var1);

    public abstract boolean isLong(int var1);

    public abstract boolean isFloat(int var1);

    public abstract boolean isDouble(int var1);

    public boolean getBoolean(int index) {
        return this.getBoolean(index, false);
    }

    public byte getByte(int index) {
        return this.getByte(index, (byte)0);
    }

    public short getShort(int index) {
        return this.getShort(index, (short)0);
    }

    public char getChar(int index) {
        return this.getChar(index, '\u0000');
    }

    public int getInt(int index) {
        return this.getInt(index, 0);
    }

    public long getLong(int index) {
        return this.getLong(index, 0L);
    }

    public float getFloat(int index) {
        return this.getFloat(index, 0.0f);
    }

    public double getDouble(int index) {
        return this.getDouble(index, 0.0);
    }

    public abstract boolean getBoolean(int var1, boolean var2);

    public abstract byte getByte(int var1, byte var2);

    public abstract short getShort(int var1, short var2);

    public abstract char getChar(int var1, char var2);

    public abstract int getInt(int var1, int var2);

    public abstract long getLong(int var1, long var2);

    public abstract float getFloat(int var1, float var2);

    public abstract double getDouble(int var1, double var2);
}

