/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.arrays;

import java.lang.reflect.Array;
import lombok.Generated;

public final class ArrayUtils {
    public static boolean contains(boolean[] array, boolean b) {
        return ArrayUtils.indexOf(array, b) != -1;
    }

    public static boolean contains(boolean[] array, boolean[] other) {
        return ArrayUtils.indexOf(array, other) != -1;
    }

    public static int indexOf(boolean[] array, boolean b) {
        for (int x = 0; x < array.length; ++x) {
            if (array[x] != b) continue;
            return x;
        }
        return -1;
    }

    public static int indexOfLast(boolean[] array, boolean b) {
        for (int x = array.length - 1; x >= 0; --x) {
            if (array[x] != b) continue;
            return x;
        }
        return -1;
    }

    public static int indexOf(boolean[] array, boolean[] other) {
        for (int x = 0; x < array.length; ++x) {
            if (array[x] != other[0]) continue;
            boolean found = true;
            for (int y = 1; y < other.length; ++y) {
                if (y + x >= array.length) {
                    return -1;
                }
                if (array[x + y] == other[y]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return x;
        }
        return -1;
    }

    public static boolean[] add(boolean[] array, boolean b) {
        return ArrayUtils.add(array, array.length, b);
    }

    public static boolean[] prepend(boolean[] array, boolean b) {
        return ArrayUtils.add(array, 0, b);
    }

    public static boolean[] add(boolean[] array, int index, boolean b) {
        boolean[] newArray = new boolean[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, index);
        newArray[index] = b;
        System.arraycopy(array, index, newArray, index + 1, array.length - index);
        return newArray;
    }

    public static boolean[] add(boolean[] array, boolean ... booleans) {
        return ArrayUtils.add(array, array.length, booleans);
    }

    public static boolean[] prepend(boolean[] array, boolean ... booleans) {
        return ArrayUtils.add(array, 0, booleans);
    }

    public static boolean[] add(boolean[] array, int index, boolean ... booleans) {
        boolean[] newArray = new boolean[array.length + booleans.length];
        System.arraycopy(array, 0, newArray, 0, index);
        System.arraycopy(booleans, 0, newArray, index, booleans.length);
        System.arraycopy(array, index, newArray, index + booleans.length, array.length - index);
        return newArray;
    }

    public static boolean[] add(boolean[] array, boolean[] ... other) {
        return ArrayUtils.add(array, array.length, other);
    }

    public static boolean[] prepend(boolean[] array, boolean[] ... other) {
        return ArrayUtils.add(array, 0, other);
    }

    public static boolean[] add(boolean[] array, int index, boolean[] ... other) {
        int length = array.length;
        for (boolean[] o : other) {
            length += o.length;
        }
        boolean[] newArray = new boolean[length];
        System.arraycopy(array, 0, newArray, 0, index);
        int i = index;
        for (boolean[] o : other) {
            System.arraycopy(o, 0, newArray, i, o.length);
            i += o.length;
        }
        System.arraycopy(array, index, newArray, i, array.length - index);
        return newArray;
    }

    public static boolean[] remove(boolean[] array, boolean b) {
        int index = ArrayUtils.indexOf(array, b);
        if (index == -1) {
            return array;
        }
        return ArrayUtils.removeAt(array, index);
    }

    public static boolean[] removeFirst(boolean[] array) {
        return ArrayUtils.removeAt(array, 0);
    }

    public static boolean[] removeLast(boolean[] array) {
        return ArrayUtils.removeAt(array, array.length - 1);
    }

    public static boolean[] removeAt(boolean[] array, int index) {
        return ArrayUtils.removeAt(array, index, 1);
    }

    public static boolean[] removeAt(boolean[] array, int index, int length) {
        boolean[] newArray = new boolean[array.length - length];
        System.arraycopy(array, 0, newArray, 0, index);
        System.arraycopy(array, index + length, newArray, index, array.length - index - length);
        return newArray;
    }

    public static void reverse(boolean[] array) {
        for (int x = 0; x < array.length / 2; ++x) {
            boolean temp = array[x];
            array[x] = array[array.length - x - 1];
            array[array.length - x - 1] = temp;
        }
    }

    public static boolean contains(byte[] array, byte b) {
        return ArrayUtils.indexOf(array, b) != -1;
    }

    public static boolean contains(byte[] array, byte[] other) {
        return ArrayUtils.indexOf(array, other) != -1;
    }

    public static int indexOf(byte[] array, byte b) {
        for (int x = 0; x < array.length; ++x) {
            if (array[x] != b) continue;
            return x;
        }
        return -1;
    }

    public static int indexOfLast(byte[] array, byte b) {
        for (int x = array.length - 1; x >= 0; --x) {
            if (array[x] != b) continue;
            return x;
        }
        return -1;
    }

    public static int indexOf(byte[] array, byte[] other) {
        for (int x = 0; x < array.length; ++x) {
            if (array[x] != other[0]) continue;
            boolean found = true;
            for (int y = 1; y < other.length; ++y) {
                if (y + x >= array.length) {
                    return -1;
                }
                if (array[x + y] == other[y]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return x;
        }
        return -1;
    }

    public static byte[] add(byte[] array, byte b) {
        return ArrayUtils.add(array, array.length, b);
    }

    public static byte[] prepend(byte[] array, byte b) {
        return ArrayUtils.add(array, 0, b);
    }

    public static byte[] add(byte[] array, int index, byte b) {
        byte[] newArray = new byte[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, index);
        newArray[index] = b;
        System.arraycopy(array, index, newArray, index + 1, array.length - index);
        return newArray;
    }

    public static byte[] add(byte[] array, byte ... bytes) {
        return ArrayUtils.add(array, array.length, bytes);
    }

    public static byte[] prepend(byte[] array, byte ... bytes) {
        return ArrayUtils.add(array, 0, bytes);
    }

    public static byte[] add(byte[] array, int index, byte ... bytes) {
        byte[] newArray = new byte[array.length + bytes.length];
        System.arraycopy(array, 0, newArray, 0, index);
        System.arraycopy(bytes, 0, newArray, index, bytes.length);
        System.arraycopy(array, index, newArray, index + bytes.length, array.length - index);
        return newArray;
    }

    public static byte[] add(byte[] array, byte[] ... other) {
        return ArrayUtils.add(array, array.length, other);
    }

    public static byte[] prepend(byte[] array, byte[] ... other) {
        return ArrayUtils.add(array, 0, other);
    }

    public static byte[] add(byte[] array, int index, byte[] ... other) {
        int length = array.length;
        for (byte[] o : other) {
            length += o.length;
        }
        byte[] newArray = new byte[length];
        System.arraycopy(array, 0, newArray, 0, index);
        int i = index;
        for (byte[] o : other) {
            System.arraycopy(o, 0, newArray, i, o.length);
            i += o.length;
        }
        System.arraycopy(array, index, newArray, i, array.length - index);
        return newArray;
    }

    public static byte[] remove(byte[] array, byte b) {
        int index = ArrayUtils.indexOf(array, b);
        if (index == -1) {
            return array;
        }
        return ArrayUtils.removeAt(array, index);
    }

    public static byte[] removeFirst(byte[] array) {
        return ArrayUtils.removeAt(array, 0);
    }

    public static byte[] removeLast(byte[] array) {
        return ArrayUtils.removeAt(array, array.length - 1);
    }

    public static byte[] removeAt(byte[] array, int index) {
        return ArrayUtils.removeAt(array, index, 1);
    }

    public static byte[] removeAt(byte[] array, int index, int length) {
        byte[] newArray = new byte[array.length - length];
        System.arraycopy(array, 0, newArray, 0, index);
        System.arraycopy(array, index + length, newArray, index, array.length - index - length);
        return newArray;
    }

    public static void reverse(byte[] array) {
        for (int x = 0; x < array.length / 2; ++x) {
            byte temp = array[x];
            array[x] = array[array.length - x - 1];
            array[array.length - x - 1] = temp;
        }
    }

    public static boolean contains(short[] array, short s) {
        return ArrayUtils.indexOf(array, s) != -1;
    }

    public static boolean contains(short[] array, short[] other) {
        return ArrayUtils.indexOf(array, other) != -1;
    }

    public static int indexOf(short[] array, short s) {
        for (int x = 0; x < array.length; ++x) {
            if (array[x] != s) continue;
            return x;
        }
        return -1;
    }

    public static int indexOfLast(short[] array, short s) {
        for (int x = array.length - 1; x >= 0; --x) {
            if (array[x] != s) continue;
            return x;
        }
        return -1;
    }

    public static int indexOf(short[] array, short[] other) {
        for (int x = 0; x < array.length; ++x) {
            if (array[x] != other[0]) continue;
            boolean found = true;
            for (int y = 1; y < other.length; ++y) {
                if (y + x >= array.length) {
                    return -1;
                }
                if (array[x + y] == other[y]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return x;
        }
        return -1;
    }

    public static short[] add(short[] array, short s) {
        return ArrayUtils.add(array, array.length, s);
    }

    public static short[] prepend(short[] array, short s) {
        return ArrayUtils.add(array, 0, s);
    }

    public static short[] add(short[] array, int index, short s) {
        short[] newArray = new short[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, index);
        newArray[index] = s;
        System.arraycopy(array, index, newArray, index + 1, array.length - index);
        return newArray;
    }

    public static short[] add(short[] array, short ... shorts) {
        return ArrayUtils.add(array, array.length, shorts);
    }

    public static short[] prepend(short[] array, short ... shorts) {
        return ArrayUtils.add(array, 0, shorts);
    }

    public static short[] add(short[] array, int index, short ... shorts) {
        short[] newArray = new short[array.length + shorts.length];
        System.arraycopy(array, 0, newArray, 0, index);
        System.arraycopy(shorts, 0, newArray, index, shorts.length);
        System.arraycopy(array, index, newArray, index + shorts.length, array.length - index);
        return newArray;
    }

    public static short[] add(short[] array, short[] ... other) {
        return ArrayUtils.add(array, array.length, other);
    }

    public static short[] prepend(short[] array, short[] ... other) {
        return ArrayUtils.add(array, 0, other);
    }

    public static short[] add(short[] array, int index, short[] ... other) {
        int length = array.length;
        for (short[] o : other) {
            length += o.length;
        }
        short[] newArray = new short[length];
        System.arraycopy(array, 0, newArray, 0, index);
        int i = index;
        for (short[] o : other) {
            System.arraycopy(o, 0, newArray, i, o.length);
            i += o.length;
        }
        System.arraycopy(array, index, newArray, i, array.length - index);
        return newArray;
    }

    public static short[] remove(short[] array, short s) {
        int index = ArrayUtils.indexOf(array, s);
        if (index == -1) {
            return array;
        }
        return ArrayUtils.removeAt(array, index);
    }

    public static short[] removeFirst(short[] array) {
        return ArrayUtils.removeAt(array, 0);
    }

    public static short[] removeLast(short[] array) {
        return ArrayUtils.removeAt(array, array.length - 1);
    }

    public static short[] removeAt(short[] array, int index) {
        return ArrayUtils.removeAt(array, index, 1);
    }

    public static short[] removeAt(short[] array, int index, int length) {
        short[] newArray = new short[array.length - length];
        System.arraycopy(array, 0, newArray, 0, index);
        System.arraycopy(array, index + length, newArray, index, array.length - index - length);
        return newArray;
    }

    public static void reverse(short[] array) {
        for (int x = 0; x < array.length / 2; ++x) {
            short temp = array[x];
            array[x] = array[array.length - x - 1];
            array[array.length - x - 1] = temp;
        }
    }

    public static boolean contains(char[] array, char c) {
        return ArrayUtils.indexOf(array, c) != -1;
    }

    public static boolean contains(char[] array, char[] other) {
        return ArrayUtils.indexOf(array, other) != -1;
    }

    public static int indexOf(char[] array, char c) {
        for (int x = 0; x < array.length; ++x) {
            if (array[x] != c) continue;
            return x;
        }
        return -1;
    }

    public static int indexOfLast(char[] array, char c) {
        for (int x = array.length - 1; x >= 0; --x) {
            if (array[x] != c) continue;
            return x;
        }
        return -1;
    }

    public static int indexOf(char[] array, char[] other) {
        for (int x = 0; x < array.length; ++x) {
            if (array[x] != other[0]) continue;
            boolean found = true;
            for (int y = 1; y < other.length; ++y) {
                if (y + x >= array.length) {
                    return -1;
                }
                if (array[x + y] == other[y]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return x;
        }
        return -1;
    }

    public static char[] add(char[] array, char c) {
        return ArrayUtils.add(array, array.length, c);
    }

    public static char[] prepend(char[] array, char c) {
        return ArrayUtils.add(array, 0, c);
    }

    public static char[] add(char[] array, int index, char c) {
        char[] newArray = new char[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, index);
        newArray[index] = c;
        System.arraycopy(array, index, newArray, index + 1, array.length - index);
        return newArray;
    }

    public static char[] add(char[] array, char ... chars) {
        return ArrayUtils.add(array, array.length, chars);
    }

    public static char[] prepend(char[] array, char ... chars) {
        return ArrayUtils.add(array, 0, chars);
    }

    public static char[] add(char[] array, int index, char ... chars) {
        char[] newArray = new char[array.length + chars.length];
        System.arraycopy(array, 0, newArray, 0, index);
        System.arraycopy(chars, 0, newArray, index, chars.length);
        System.arraycopy(array, index, newArray, index + chars.length, array.length - index);
        return newArray;
    }

    public static char[] add(char[] array, char[] ... other) {
        return ArrayUtils.add(array, array.length, other);
    }

    public static char[] prepend(char[] array, char[] ... other) {
        return ArrayUtils.add(array, 0, other);
    }

    public static char[] add(char[] array, int index, char[] ... other) {
        int length = array.length;
        for (char[] o : other) {
            length += o.length;
        }
        char[] newArray = new char[length];
        System.arraycopy(array, 0, newArray, 0, index);
        int i = index;
        for (char[] o : other) {
            System.arraycopy(o, 0, newArray, i, o.length);
            i += o.length;
        }
        System.arraycopy(array, index, newArray, i, array.length - index);
        return newArray;
    }

    public static char[] remove(char[] array, char c) {
        int index = ArrayUtils.indexOf(array, c);
        if (index == -1) {
            return array;
        }
        return ArrayUtils.removeAt(array, index);
    }

    public static char[] removeFirst(char[] array) {
        return ArrayUtils.removeAt(array, 0);
    }

    public static char[] removeLast(char[] array) {
        return ArrayUtils.removeAt(array, array.length - 1);
    }

    public static char[] removeAt(char[] array, int index) {
        return ArrayUtils.removeAt(array, index, 1);
    }

    public static char[] removeAt(char[] array, int index, int length) {
        char[] newArray = new char[array.length - length];
        System.arraycopy(array, 0, newArray, 0, index);
        System.arraycopy(array, index + length, newArray, index, array.length - index - length);
        return newArray;
    }

    public static void reverse(char[] array) {
        for (int x = 0; x < array.length / 2; ++x) {
            char temp = array[x];
            array[x] = array[array.length - x - 1];
            array[array.length - x - 1] = temp;
        }
    }

    public static boolean contains(int[] array, int i) {
        return ArrayUtils.indexOf(array, i) != -1;
    }

    public static boolean contains(int[] array, int[] other) {
        return ArrayUtils.indexOf(array, other) != -1;
    }

    public static int indexOf(int[] array, int i) {
        for (int x = 0; x < array.length; ++x) {
            if (array[x] != i) continue;
            return x;
        }
        return -1;
    }

    public static int indexOfLast(int[] array, int i) {
        for (int x = array.length - 1; x >= 0; --x) {
            if (array[x] != i) continue;
            return x;
        }
        return -1;
    }

    public static int indexOf(int[] array, int[] other) {
        for (int x = 0; x < array.length; ++x) {
            if (array[x] != other[0]) continue;
            boolean found = true;
            for (int y = 1; y < other.length; ++y) {
                if (y + x >= array.length) {
                    return -1;
                }
                if (array[x + y] == other[y]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return x;
        }
        return -1;
    }

    public static int[] add(int[] array, int i) {
        return ArrayUtils.add(array, array.length, i);
    }

    public static int[] prepend(int[] array, int i) {
        return ArrayUtils.add(array, 0, i);
    }

    public static int[] add(int[] array, int index, int i) {
        int[] newArray = new int[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, index);
        newArray[index] = i;
        System.arraycopy(array, index, newArray, index + 1, array.length - index);
        return newArray;
    }

    public static int[] add(int[] array, int ... ints) {
        return ArrayUtils.add(array, array.length, ints);
    }

    public static int[] prepend(int[] array, int ... ints) {
        return ArrayUtils.add(array, 0, ints);
    }

    public static int[] add(int[] array, int index, int ... ints) {
        int[] newArray = new int[array.length + ints.length];
        System.arraycopy(array, 0, newArray, 0, index);
        System.arraycopy(ints, 0, newArray, index, ints.length);
        System.arraycopy(array, index, newArray, index + ints.length, array.length - index);
        return newArray;
    }

    public static int[] add(int[] array, int[] ... other) {
        return ArrayUtils.add(array, array.length, other);
    }

    public static int[] prepend(int[] array, int[] ... other) {
        return ArrayUtils.add(array, 0, other);
    }

    public static int[] add(int[] array, int index, int[] ... other) {
        int length = array.length;
        for (int[] o : other) {
            length += o.length;
        }
        int[] newArray = new int[length];
        System.arraycopy(array, 0, newArray, 0, index);
        int i = index;
        for (int[] o : other) {
            System.arraycopy(o, 0, newArray, i, o.length);
            i += o.length;
        }
        System.arraycopy(array, index, newArray, i, array.length - index);
        return newArray;
    }

    public static int[] remove(int[] array, int i) {
        int index = ArrayUtils.indexOf(array, i);
        if (index == -1) {
            return array;
        }
        return ArrayUtils.removeAt(array, index);
    }

    public static int[] removeFirst(int[] array) {
        return ArrayUtils.removeAt(array, 0);
    }

    public static int[] removeLast(int[] array) {
        return ArrayUtils.removeAt(array, array.length - 1);
    }

    public static int[] removeAt(int[] array, int index) {
        return ArrayUtils.removeAt(array, index, 1);
    }

    public static int[] removeAt(int[] array, int index, int length) {
        int[] newArray = new int[array.length - length];
        System.arraycopy(array, 0, newArray, 0, index);
        System.arraycopy(array, index + length, newArray, index, array.length - index - length);
        return newArray;
    }

    public static void reverse(int[] array) {
        for (int x = 0; x < array.length / 2; ++x) {
            int temp = array[x];
            array[x] = array[array.length - x - 1];
            array[array.length - x - 1] = temp;
        }
    }

    public static boolean contains(long[] array, long l) {
        return ArrayUtils.indexOf(array, l) != -1;
    }

    public static boolean contains(long[] array, long[] other) {
        return ArrayUtils.indexOf(array, other) != -1;
    }

    public static int indexOf(long[] array, long l) {
        for (int x = 0; x < array.length; ++x) {
            if (array[x] != l) continue;
            return x;
        }
        return -1;
    }

    public static int indexOfLast(long[] array, long l) {
        for (int x = array.length - 1; x >= 0; --x) {
            if (array[x] != l) continue;
            return x;
        }
        return -1;
    }

    public static int indexOf(long[] array, long[] other) {
        for (int x = 0; x < array.length; ++x) {
            if (array[x] != other[0]) continue;
            boolean found = true;
            for (int y = 1; y < other.length; ++y) {
                if (y + x >= array.length) {
                    return -1;
                }
                if (array[x + y] == other[y]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return x;
        }
        return -1;
    }

    public static long[] add(long[] array, long l) {
        return ArrayUtils.add(array, array.length, l);
    }

    public static long[] prepend(long[] array, long l) {
        return ArrayUtils.add(array, 0, l);
    }

    public static long[] add(long[] array, int index, long l) {
        long[] newArray = new long[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, index);
        newArray[index] = l;
        System.arraycopy(array, index, newArray, index + 1, array.length - index);
        return newArray;
    }

    public static long[] add(long[] array, long ... longs) {
        return ArrayUtils.add(array, array.length, longs);
    }

    public static long[] prepend(long[] array, long ... longs) {
        return ArrayUtils.add(array, 0, longs);
    }

    public static long[] add(long[] array, int index, long ... longs) {
        long[] newArray = new long[array.length + longs.length];
        System.arraycopy(array, 0, newArray, 0, index);
        System.arraycopy(longs, 0, newArray, index, longs.length);
        System.arraycopy(array, index, newArray, index + longs.length, array.length - index);
        return newArray;
    }

    public static long[] add(long[] array, long[] ... other) {
        return ArrayUtils.add(array, array.length, other);
    }

    public static long[] prepend(long[] array, long[] ... other) {
        return ArrayUtils.add(array, 0, other);
    }

    public static long[] add(long[] array, int index, long[] ... other) {
        int length = array.length;
        for (long[] o : other) {
            length += o.length;
        }
        long[] newArray = new long[length];
        System.arraycopy(array, 0, newArray, 0, index);
        int i = index;
        for (long[] o : other) {
            System.arraycopy(o, 0, newArray, i, o.length);
            i += o.length;
        }
        System.arraycopy(array, index, newArray, i, array.length - index);
        return newArray;
    }

    public static long[] remove(long[] array, long l) {
        int index = ArrayUtils.indexOf(array, l);
        if (index == -1) {
            return array;
        }
        return ArrayUtils.removeAt(array, index);
    }

    public static long[] removeFirst(long[] array) {
        return ArrayUtils.removeAt(array, 0);
    }

    public static long[] removeLast(long[] array) {
        return ArrayUtils.removeAt(array, array.length - 1);
    }

    public static long[] removeAt(long[] array, int index) {
        return ArrayUtils.removeAt(array, index, 1);
    }

    public static long[] removeAt(long[] array, int index, int length) {
        long[] newArray = new long[array.length - length];
        System.arraycopy(array, 0, newArray, 0, index);
        System.arraycopy(array, index + length, newArray, index, array.length - index - length);
        return newArray;
    }

    public static void reverse(long[] array) {
        for (int x = 0; x < array.length / 2; ++x) {
            long temp = array[x];
            array[x] = array[array.length - x - 1];
            array[array.length - x - 1] = temp;
        }
    }

    public static boolean contains(float[] array, float f) {
        return ArrayUtils.indexOf(array, f) != -1;
    }

    public static boolean contains(float[] array, float[] other) {
        return ArrayUtils.indexOf(array, other) != -1;
    }

    public static int indexOf(float[] array, float f) {
        for (int x = 0; x < array.length; ++x) {
            if (array[x] != f) continue;
            return x;
        }
        return -1;
    }

    public static int indexOfLast(float[] array, float f) {
        for (int x = array.length - 1; x >= 0; --x) {
            if (array[x] != f) continue;
            return x;
        }
        return -1;
    }

    public static int indexOf(float[] array, float[] other) {
        for (int x = 0; x < array.length; ++x) {
            if (array[x] != other[0]) continue;
            boolean found = true;
            for (int y = 1; y < other.length; ++y) {
                if (y + x >= array.length) {
                    return -1;
                }
                if (array[x + y] == other[y]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return x;
        }
        return -1;
    }

    public static float[] add(float[] array, float f) {
        return ArrayUtils.add(array, array.length, f);
    }

    public static float[] prepend(float[] array, float f) {
        return ArrayUtils.add(array, 0, f);
    }

    public static float[] add(float[] array, int index, float f) {
        float[] newArray = new float[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, index);
        newArray[index] = f;
        System.arraycopy(array, index, newArray, index + 1, array.length - index);
        return newArray;
    }

    public static float[] add(float[] array, float ... floats) {
        return ArrayUtils.add(array, array.length, floats);
    }

    public static float[] prepend(float[] array, float ... floats) {
        return ArrayUtils.add(array, 0, floats);
    }

    public static float[] add(float[] array, int index, float ... floats) {
        float[] newArray = new float[array.length + floats.length];
        System.arraycopy(array, 0, newArray, 0, index);
        System.arraycopy(floats, 0, newArray, index, floats.length);
        System.arraycopy(array, index, newArray, index + floats.length, array.length - index);
        return newArray;
    }

    public static float[] add(float[] array, float[] ... other) {
        return ArrayUtils.add(array, array.length, other);
    }

    public static float[] prepend(float[] array, float[] ... other) {
        return ArrayUtils.add(array, 0, other);
    }

    public static float[] add(float[] array, int index, float[] ... other) {
        int length = array.length;
        for (float[] o : other) {
            length += o.length;
        }
        float[] newArray = new float[length];
        System.arraycopy(array, 0, newArray, 0, index);
        int i = index;
        for (float[] o : other) {
            System.arraycopy(o, 0, newArray, i, o.length);
            i += o.length;
        }
        System.arraycopy(array, index, newArray, i, array.length - index);
        return newArray;
    }

    public static float[] remove(float[] array, float f) {
        int index = ArrayUtils.indexOf(array, f);
        if (index == -1) {
            return array;
        }
        return ArrayUtils.removeAt(array, index);
    }

    public static float[] removeFirst(float[] array) {
        return ArrayUtils.removeAt(array, 0);
    }

    public static float[] removeLast(float[] array) {
        return ArrayUtils.removeAt(array, array.length - 1);
    }

    public static float[] removeAt(float[] array, int index) {
        return ArrayUtils.removeAt(array, index, 1);
    }

    public static float[] removeAt(float[] array, int index, int length) {
        float[] newArray = new float[array.length - length];
        System.arraycopy(array, 0, newArray, 0, index);
        System.arraycopy(array, index + length, newArray, index, array.length - index - length);
        return newArray;
    }

    public static void reverse(float[] array) {
        for (int x = 0; x < array.length / 2; ++x) {
            float temp = array[x];
            array[x] = array[array.length - x - 1];
            array[array.length - x - 1] = temp;
        }
    }

    public static boolean contains(double[] array, double d) {
        return ArrayUtils.indexOf(array, d) != -1;
    }

    public static boolean contains(double[] array, double[] other) {
        return ArrayUtils.indexOf(array, other) != -1;
    }

    public static int indexOf(double[] array, double d) {
        for (int x = 0; x < array.length; ++x) {
            if (array[x] != d) continue;
            return x;
        }
        return -1;
    }

    public static int indexOfLast(double[] array, double d) {
        for (int x = array.length - 1; x >= 0; --x) {
            if (array[x] != d) continue;
            return x;
        }
        return -1;
    }

    public static int indexOf(double[] array, double[] other) {
        for (int x = 0; x < array.length; ++x) {
            if (array[x] != other[0]) continue;
            boolean found = true;
            for (int y = 1; y < other.length; ++y) {
                if (y + x >= array.length) {
                    return -1;
                }
                if (array[x + y] == other[y]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return x;
        }
        return -1;
    }

    public static double[] add(double[] array, double d) {
        return ArrayUtils.add(array, array.length, d);
    }

    public static double[] prepend(double[] array, double d) {
        return ArrayUtils.add(array, 0, d);
    }

    public static double[] add(double[] array, int index, double d) {
        double[] newArray = new double[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, index);
        newArray[index] = d;
        System.arraycopy(array, index, newArray, index + 1, array.length - index);
        return newArray;
    }

    public static double[] add(double[] array, double ... doubles) {
        return ArrayUtils.add(array, array.length, doubles);
    }

    public static double[] prepend(double[] array, double ... doubles) {
        return ArrayUtils.add(array, 0, doubles);
    }

    public static double[] add(double[] array, int index, double ... doubles) {
        double[] newArray = new double[array.length + doubles.length];
        System.arraycopy(array, 0, newArray, 0, index);
        System.arraycopy(doubles, 0, newArray, index, doubles.length);
        System.arraycopy(array, index, newArray, index + doubles.length, array.length - index);
        return newArray;
    }

    public static double[] add(double[] array, double[] ... other) {
        return ArrayUtils.add(array, array.length, other);
    }

    public static double[] prepend(double[] array, double[] ... other) {
        return ArrayUtils.add(array, 0, other);
    }

    public static double[] add(double[] array, int index, double[] ... other) {
        int length = array.length;
        for (double[] o : other) {
            length += o.length;
        }
        double[] newArray = new double[length];
        System.arraycopy(array, 0, newArray, 0, index);
        int i = index;
        for (double[] o : other) {
            System.arraycopy(o, 0, newArray, i, o.length);
            i += o.length;
        }
        System.arraycopy(array, index, newArray, i, array.length - index);
        return newArray;
    }

    public static double[] remove(double[] array, double d) {
        int index = ArrayUtils.indexOf(array, d);
        if (index == -1) {
            return array;
        }
        return ArrayUtils.removeAt(array, index);
    }

    public static double[] removeFirst(double[] array) {
        return ArrayUtils.removeAt(array, 0);
    }

    public static double[] removeLast(double[] array) {
        return ArrayUtils.removeAt(array, array.length - 1);
    }

    public static double[] removeAt(double[] array, int index) {
        return ArrayUtils.removeAt(array, index, 1);
    }

    public static double[] removeAt(double[] array, int index, int length) {
        double[] newArray = new double[array.length - length];
        System.arraycopy(array, 0, newArray, 0, index);
        System.arraycopy(array, index + length, newArray, index, array.length - index - length);
        return newArray;
    }

    public static void reverse(double[] array) {
        for (int x = 0; x < array.length / 2; ++x) {
            double temp = array[x];
            array[x] = array[array.length - x - 1];
            array[array.length - x - 1] = temp;
        }
    }

    public static <O> boolean contains(O[] array, O o) {
        return ArrayUtils.indexOf(array, o) != -1;
    }

    public static <O> boolean contains(O[] array, O[] other) {
        return ArrayUtils.indexOf(array, other) != -1;
    }

    public static <O> int indexOf(O[] array, O o) {
        for (int x = 0; x < array.length; ++x) {
            if (array[x] != o) continue;
            return x;
        }
        return -1;
    }

    public static <O> int indexOfLast(O[] array, O o) {
        for (int x = array.length - 1; x >= 0; --x) {
            if (array[x] != o) continue;
            return x;
        }
        return -1;
    }

    public static <O> int indexOf(O[] array, O[] other) {
        for (int x = 0; x < array.length; ++x) {
            if (array[x] != other[0]) continue;
            boolean found = true;
            for (int y = 1; y < other.length; ++y) {
                if (y + x >= array.length) {
                    return -1;
                }
                if (array[x + y] == other[y]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return x;
        }
        return -1;
    }

    public static <O> O[] add(O[] array, O o) {
        return ArrayUtils.add(array, array.length, o);
    }

    public static <O> O[] prepend(O[] array, O o) {
        return ArrayUtils.add(array, 0, o);
    }

    public static <O> O[] add(O[] array, int index, O o) {
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + 1);
        System.arraycopy(array, 0, newArray, 0, index);
        newArray[index] = o;
        System.arraycopy(array, index, newArray, index + 1, array.length - index);
        return newArray;
    }

    @SafeVarargs
    public static <O> O[] add(O[] array, O ... objects) {
        return ArrayUtils.add(array, array.length, objects);
    }

    @SafeVarargs
    public static <O> O[] prepend(O[] array, O ... objects) {
        return ArrayUtils.add(array, 0, objects);
    }

    @SafeVarargs
    public static <O> O[] add(O[] array, int index, O ... objects) {
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + objects.length);
        System.arraycopy(array, 0, newArray, 0, index);
        System.arraycopy(objects, 0, newArray, index, objects.length);
        System.arraycopy(array, index, newArray, index + objects.length, array.length - index);
        return newArray;
    }

    @SafeVarargs
    public static <O> O[] add(O[] array, O[] ... other) {
        return ArrayUtils.add(array, array.length, other);
    }

    @SafeVarargs
    public static <O> O[] prepend(O[] array, O[] ... other) {
        return ArrayUtils.add(array, 0, other);
    }

    @SafeVarargs
    public static <O> O[] add(O[] array, int index, O[] ... other) {
        int length = array.length;
        for (O[] o : other) {
            length += o.length;
        }
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), length);
        System.arraycopy(array, 0, newArray, 0, index);
        int i = index;
        for (O[] o : other) {
            System.arraycopy(o, 0, newArray, i, o.length);
            i += o.length;
        }
        System.arraycopy(array, index, newArray, i, array.length - index);
        return newArray;
    }

    public static <O> O[] remove(O[] array, O o) {
        int index = ArrayUtils.indexOf(array, o);
        if (index == -1) {
            return array;
        }
        return ArrayUtils.removeAt(array, index);
    }

    public static <O> O[] removeFirst(O[] array) {
        return ArrayUtils.removeAt(array, 0);
    }

    public static <O> O[] removeLast(O[] array) {
        return ArrayUtils.removeAt(array, array.length - 1);
    }

    public static <O> O[] removeAt(O[] array, int index) {
        return ArrayUtils.removeAt(array, index, 1);
    }

    public static <O> O[] removeAt(O[] array, int index, int length) {
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length - length);
        System.arraycopy(array, 0, newArray, 0, index);
        System.arraycopy(array, index + length, newArray, index, array.length - index - length);
        return newArray;
    }

    public static <O> void reverse(O[] array) {
        for (int x = 0; x < array.length / 2; ++x) {
            O temp = array[x];
            array[x] = array[array.length - x - 1];
            array[array.length - x - 1] = temp;
        }
    }

    @Generated
    private ArrayUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

