/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import lombok.Generated;

public final class RandomUtils {
    private static final Random RND = new Random();

    public static String randomString(int length) {
        return RandomUtils.randomString(length, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_");
    }

    public static String randomString(int length, String charset) {
        char[] out = new char[length];
        for (int i = 0; i < length; ++i) {
            out[i] = charset.charAt(RND.nextInt(charset.length()));
        }
        return new String(out);
    }

    public static String randomizeCase(String s) {
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = RND.nextBoolean() ? Character.toUpperCase(chars[i]) : Character.toLowerCase(chars[i]);
        }
        return new String(chars);
    }

    public static int randomInt(int min, int max) {
        int rMax;
        int rMin;
        if (min == max) {
            return min;
        }
        if (min > max) {
            rMin = max;
            rMax = min;
        } else {
            rMin = min;
            rMax = max;
        }
        return RND.nextInt(rMax - rMin) + rMin;
    }

    public static long randomLong(long min, long max) {
        long rMax;
        long rMin;
        if (min == max) {
            return min;
        }
        if (min > max) {
            rMin = max;
            rMax = min;
        } else {
            rMin = min;
            rMax = max;
        }
        return (long)(RND.nextDouble() * (double)(rMax - rMin)) + rMin;
    }

    public static double randomDouble(double min, double max) {
        double rMax;
        double rMin;
        if (min == max) {
            return min;
        }
        if (min > max) {
            rMin = max;
            rMax = min;
        } else {
            rMin = min;
            rMax = max;
        }
        return RND.nextDouble() * (rMax - rMin) + rMin;
    }

    public static byte[] randomBytes(int length) {
        byte[] bytes = new byte[length];
        RND.nextBytes(bytes);
        return bytes;
    }

    @Nullable
    public static <T> T randomElement(T[] array) {
        if (array.length == 0) {
            return null;
        }
        if (array.length == 1) {
            return array[0];
        }
        return array[RND.nextInt(array.length)];
    }

    @Nullable
    public static <T> T randomElement(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return list.get(RND.nextInt(list.size()));
    }

    @Generated
    private RandomUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

