/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.collections.sets;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.lenni0451.commons.collections.iterators.DelegateIterator;
import net.lenni0451.commons.collections.sets.DelegateSet;

public class DelegateListenerSet<E>
extends DelegateSet<E> {
    private final Consumer<E> addListener;
    private final Consumer<E> removeListener;

    public DelegateListenerSet(Set<E> delegate, Consumer<E> addListener, Consumer<E> removeListener) {
        super(delegate);
        this.addListener = addListener;
        this.removeListener = removeListener;
    }

    @Override
    @Nonnull
    public Iterator<E> iterator() {
        return new DelegateIterator<E>(super.iterator()){

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove is not supported on this iterator");
            }
        };
    }

    @Override
    public boolean add(E e) {
        this.addListener.accept(e);
        return super.add(e);
    }

    @Override
    public boolean remove(Object o) {
        this.removeListener.accept(o);
        return super.remove(o);
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends E> c) {
        for (E e : c) {
            this.addListener.accept(e);
        }
        return super.addAll(c);
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> c) {
        for (E o : this) {
            if (c.contains(o)) continue;
            this.removeListener.accept(o);
        }
        return super.retainAll(c);
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> c) {
        for (Object o : c) {
            this.removeListener.accept(o);
        }
        return super.removeAll(c);
    }

    @Override
    public void clear() {
        this.forEach(this.removeListener);
        super.clear();
    }
}

