/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.collections.pool;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.lenni0451.commons.collections.pool.ObjectPool;

public abstract class LazyObjectPool<T>
extends ObjectPool<T> {
    protected final Map<T, Long> timestamps = this.createTimestampsMap();

    protected <K> Map<K, Long> createTimestampsMap() {
        return new HashMap();
    }

    protected void cleanup(long timeoutMs) {
        Iterator<Map.Entry<T, Long>> it = this.timestamps.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<T, Long> entry = it.next();
            if (!this.free.contains(entry.getKey()) || System.nanoTime() - entry.getValue() <= timeoutMs * 1000000L) continue;
            it.remove();
            this.free.remove(entry.getKey());
            this.onCleanup(entry.getKey());
        }
    }

    protected void onCleanup(T object) {
    }

    @Override
    public T borrowObject() {
        Object object = this.free.isEmpty() ? this.create() : this.free.remove(0);
        this.used.add(object);
        this.timestamps.put(object, System.nanoTime());
        return object;
    }

    @Override
    public void returnObject(T object) {
        if (!this.used.remove(object)) {
            throw new IllegalArgumentException("Object not borrowed from this pool");
        }
        this.free.add(object);
    }
}

