/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.collections.pool;

import javax.annotation.Nullable;
import net.lenni0451.commons.collections.pool.ObjectPool;

public abstract class FixedObjectPool<T>
extends ObjectPool<T> {
    public FixedObjectPool(int size) {
        for (int i = 0; i < size; ++i) {
            this.free.add(this.create());
        }
    }

    @Override
    public T borrowObject() {
        if (this.free.isEmpty()) {
            throw new IllegalStateException("No objects available in the pool");
        }
        Object object = this.free.remove(0);
        this.used.add(object);
        return (T)object;
    }

    @Nullable
    public T tryBorrowObject() {
        if (this.free.isEmpty()) {
            return null;
        }
        Object object = this.free.remove(0);
        this.used.add(object);
        return (T)object;
    }

    @Override
    public void returnObject(T object) {
        if (!this.used.remove(object)) {
            throw new IllegalArgumentException("Object not borrowed from this pool");
        }
        this.free.add(object);
    }
}

