/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.collections.maps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.lenni0451.commons.collections.collections.DelegateCollection;
import net.lenni0451.commons.collections.iterators.DelegateIterator;
import net.lenni0451.commons.collections.maps.DelegateMap;
import net.lenni0451.commons.collections.sets.DelegateSet;

@NotThreadSafe
public class SizeConstrainedMap<K, V>
extends DelegateMap<K, V> {
    private final List<K> keys;
    private final int maxSize;
    private KeySet keySet;
    private Values values;
    private EntrySet entrySet;

    public SizeConstrainedMap(Map<K, V> delegate, int maxSize) {
        super(delegate);
        if (!delegate.isEmpty()) {
            throw new IllegalArgumentException("Delegate map must be empty");
        }
        this.keys = new ArrayList<K>();
        this.maxSize = maxSize;
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        V returnValue = super.put(key, value);
        if (this.keys.size() >= this.maxSize) {
            super.remove(this.keys.remove(0));
        }
        this.keys.add(key);
        return returnValue;
    }

    @Override
    public V remove(Object key) {
        Object returnValue = super.remove(key);
        this.keys.remove(key);
        return returnValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.keys.clear();
    }

    @Override
    @Nonnull
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet(super.keySet());
        }
        return this.keySet;
    }

    @Override
    @Nonnull
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values(super.values());
        }
        return this.values;
    }

    @Override
    @Nonnull
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet(super.entrySet());
        }
        return this.entrySet;
    }

    private class EntrySet
    extends DelegateSet<Map.Entry<K, V>> {
        public EntrySet(Set<Map.Entry<K, V>> delegate) {
            super(delegate);
        }

        @Override
        @Nonnull
        public Iterator<Map.Entry<K, V>> iterator() {
            return new DelegateIterator<Map.Entry<K, V>>(super.iterator()){
                private Map.Entry<K, V> lastEntry;

                @Override
                public Map.Entry<K, V> next() {
                    this.lastEntry = (Map.Entry)super.next();
                    return this.lastEntry;
                }

                @Override
                public void remove() {
                    super.remove();
                    SizeConstrainedMap.this.keys.remove(this.lastEntry.getKey());
                }
            };
        }

        @Override
        public boolean add(Map.Entry<K, V> kvEntry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(@Nonnull Collection<? extends Map.Entry<K, V>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            boolean returnValue = super.remove(o);
            if (returnValue) {
                SizeConstrainedMap.this.keys.remove(((Map.Entry)o).getKey());
            }
            return returnValue;
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            boolean returnValue = super.retainAll(c);
            if (returnValue) {
                for (Map.Entry entry : this) {
                    if (c.contains(entry)) continue;
                    SizeConstrainedMap.this.keys.remove(entry.getKey());
                }
            }
            return returnValue;
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            boolean returnValue = super.removeAll(c);
            if (returnValue) {
                for (Object o : c) {
                    if (!(o instanceof Map.Entry)) continue;
                    SizeConstrainedMap.this.keys.remove(((Map.Entry)o).getKey());
                }
            }
            return returnValue;
        }
    }

    private class Values
    extends DelegateCollection<V> {
        public Values(Collection<V> delegate) {
            super(delegate);
        }

        @Override
        @Nonnull
        public Iterator<V> iterator() {
            return new DelegateIterator<V>(super.iterator()){

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean add(V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(@Nonnull Collection<? extends V> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    private class KeySet
    extends DelegateSet<K> {
        public KeySet(Set<K> delegate) {
            super(delegate);
        }

        @Override
        @Nonnull
        public Iterator<K> iterator() {
            return new DelegateIterator<K>(super.iterator()){
                private K lastKey;

                @Override
                public K next() {
                    this.lastKey = super.next();
                    return this.lastKey;
                }

                @Override
                public void remove() {
                    super.remove();
                    SizeConstrainedMap.this.keys.remove(this.lastKey);
                }
            };
        }

        @Override
        public boolean add(K k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(@Nonnull Collection<? extends K> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            boolean returnValue = super.remove(o);
            if (returnValue) {
                SizeConstrainedMap.this.keys.remove(o);
            }
            return returnValue;
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            boolean returnValue = super.retainAll(c);
            if (returnValue) {
                SizeConstrainedMap.this.keys.retainAll(c);
            }
            return returnValue;
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            boolean returnValue = super.removeAll(c);
            if (returnValue) {
                SizeConstrainedMap.this.keys.removeAll(c);
            }
            return returnValue;
        }
    }
}

