/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.collections;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;

public final class Sets {
    public static <T> LinkedHashSet<T> sort(Set<T> set, Comparator<T> comparator) {
        return set.stream().sorted(comparator).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @SafeVarargs
    public static <T> Set<T> merge(Set<T> set, Set<T> ... others) {
        HashSet<T> newSet = new HashSet<T>(set);
        for (Set<T> other : others) {
            newSet.addAll(other);
        }
        return newSet;
    }

    @SafeVarargs
    public static <T extends Set<O>, O> T any(Supplier<T> setSupplier, O ... objects) {
        Set set = (Set)setSupplier.get();
        Collections.addAll(set, objects);
        return (T)set;
    }

    public static <T extends Set<O>, O> T any(Supplier<T> setSupplier, Consumer<T> setConsumer) {
        Set set = (Set)setSupplier.get();
        setConsumer.accept(set);
        return (T)set;
    }

    @SafeVarargs
    public static <T> HashSet<T> hashSet(T ... objects) {
        return Sets.any(HashSet::new, objects);
    }

    public static <T> HashSet<T> hashSet(Consumer<HashSet<T>> setConsumer) {
        return Sets.any(HashSet::new, setConsumer);
    }

    @SafeVarargs
    public static <T> LinkedHashSet<T> linkedHashSet(T ... objects) {
        return Sets.any(LinkedHashSet::new, objects);
    }

    public static <T> LinkedHashSet<T> linkedHashSet(Consumer<LinkedHashSet<T>> setConsumer) {
        return Sets.any(LinkedHashSet::new, setConsumer);
    }

    @SafeVarargs
    public static <T> ConcurrentSkipListSet<T> concurrentSkipListSet(T ... objects) {
        return Sets.any(ConcurrentSkipListSet::new, objects);
    }

    public static <T> ConcurrentSkipListSet<T> concurrentSkipListSet(Consumer<ConcurrentSkipListSet<T>> setConsumer) {
        return Sets.any(ConcurrentSkipListSet::new, setConsumer);
    }

    @SafeVarargs
    public static <T> Set<T> identitySet(T ... objects) {
        return Sets.any(() -> Collections.newSetFromMap(new IdentityHashMap()), objects);
    }

    public static <T> Set<T> identitySet(Consumer<Set<T>> setConsumer) {
        return Sets.any(() -> Collections.newSetFromMap(new IdentityHashMap()), setConsumer);
    }

    @Generated
    private Sets() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

