/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.collections;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;

public final class Maps {
    public static <K, V> LinkedHashMap<K, V> sort(Map<K, V> map, Comparator<Map.Entry<K, V>> comparator) {
        return map.entrySet().stream().sorted(comparator).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (k, v) -> {
            throw new IllegalStateException("Duplicate key '" + k + "' (" + v + ")");
        }, LinkedHashMap::new));
    }

    @SafeVarargs
    public static <K, V> Map<K, V> merge(Map<K, V> map, Map<K, V> ... others) {
        HashMap<K, V> newMap = new HashMap<K, V>(map);
        for (Map<K, V> other : others) {
            newMap.putAll(other);
        }
        return newMap;
    }

    public static <T extends Map<K, V>, K, V> T any(Supplier<T> mapSupplier, Object ... objects) {
        if (objects.length % 2 != 0) {
            throw new IllegalArgumentException("Uneven object count");
        }
        Map map = (Map)mapSupplier.get();
        for (int i = 0; i < objects.length; i += 2) {
            map.put(objects[i], objects[i + 1]);
        }
        return (T)map;
    }

    public static <T extends Map<K, V>, K, V> T any(Supplier<T> mapSupplier, Consumer<T> mapConsumer) {
        Map map = (Map)mapSupplier.get();
        mapConsumer.accept(map);
        return (T)map;
    }

    public static <K, V> HashMap<K, V> hashMap(Object ... objects) {
        return Maps.any(HashMap::new, objects);
    }

    public static <K, V> HashMap<K, V> hashMap(Consumer<HashMap<K, V>> mapConsumer) {
        return Maps.any(HashMap::new, mapConsumer);
    }

    public static <K, V> LinkedHashMap<K, V> linkedHashMap(Object ... objects) {
        return Maps.any(LinkedHashMap::new, objects);
    }

    public static <K, V> LinkedHashMap<K, V> linkedHashMap(Consumer<LinkedHashMap<K, V>> mapConsumer) {
        return Maps.any(LinkedHashMap::new, mapConsumer);
    }

    public static <K, V> ConcurrentHashMap<K, V> concurrentHashMap(Object ... objects) {
        return Maps.any(ConcurrentHashMap::new, objects);
    }

    public static <K, V> ConcurrentHashMap<K, V> concurrentHashMap(Consumer<ConcurrentHashMap<K, V>> mapConsumer) {
        return Maps.any(ConcurrentHashMap::new, mapConsumer);
    }

    @Generated
    private Maps() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

