/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.collections;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;

public final class MapOps {
    public static void recursivePutAll(Map<?, ?> map, Map<?, ?> other) {
        MapOps.recursivePutAll(map, other, Map.class::isInstance, Map.class::cast);
    }

    public static <V> void recursivePutAll(Map<?, ?> map, Map<?, ?> other, Function<Object, Boolean> valueMapCheck, Function<V, Map<?, ?>> valueToMap) {
        for (Map.Entry<?, ?> entry : other.entrySet()) {
            if (map.containsKey(entry.getKey())) {
                Object rawValue1 = map.get(entry.getKey());
                Object rawValue2 = entry.getValue();
                if (valueMapCheck.apply(rawValue1).booleanValue() && valueMapCheck.apply(rawValue2).booleanValue()) {
                    MapOps.recursivePutAll(valueToMap.apply(map.get(entry.getKey())), valueToMap.apply(entry.getValue()), valueMapCheck, valueToMap);
                    continue;
                }
                MapOps.uncheckedPut(map, entry.getKey(), entry.getValue());
                continue;
            }
            MapOps.uncheckedPut(map, entry.getKey(), entry.getValue());
        }
    }

    public static Map<?, ?> getDuplicates(Map<?, ?> map1, Map<?, ?> map2) {
        return MapOps.getDuplicates(map1, map2, Map.class::isInstance, Map.class::cast);
    }

    public static <V> Map<?, ?> getDuplicates(Map<?, ?> map1, Map<?, ?> map2, Function<Object, Boolean> valueMapCheck, Function<V, Map<?, ?>> valueToMap) {
        HashMap duplicates = new HashMap();
        for (Map.Entry<?, ?> entry : map1.entrySet()) {
            Map<?, ?> subDuplicates;
            if (!map2.containsKey(entry.getKey())) continue;
            if (map2.get(entry.getKey()).equals(entry.getValue())) {
                duplicates.put(entry.getKey(), entry.getValue());
                continue;
            }
            Object rawValue1 = entry.getValue();
            Object rawValue2 = map2.get(entry.getKey());
            if (!valueMapCheck.apply(rawValue1).booleanValue() || !valueMapCheck.apply(rawValue2).booleanValue() || (subDuplicates = MapOps.getDuplicates(valueToMap.apply(entry.getValue()), valueToMap.apply(map2.get(entry.getKey())), valueMapCheck, valueToMap)).isEmpty()) continue;
            duplicates.put(entry.getKey(), subDuplicates);
        }
        return duplicates;
    }

    public static Map<?, ?> getUniques(Map<?, ?> map, Map<?, ?> other) {
        return MapOps.getUniques(map, other, Map.class::isInstance, Map.class::cast);
    }

    public static <V> Map<?, ?> getUniques(Map<?, ?> map, Map<?, ?> other, Function<Object, Boolean> valueMapCheck, Function<V, Map<?, ?>> valueToMap) {
        HashMap uniques = new HashMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!other.containsKey(entry.getKey())) {
                uniques.put(entry.getKey(), entry.getValue());
                continue;
            }
            Object rawValue1 = entry.getValue();
            Object rawValue2 = other.get(entry.getKey());
            if (valueMapCheck.apply(rawValue1).booleanValue() && valueMapCheck.apply(rawValue2).booleanValue()) {
                Map<?, ?> subUniques = MapOps.getUniques(valueToMap.apply(entry.getValue()), valueToMap.apply(other.get(entry.getKey())), valueMapCheck, valueToMap);
                if (subUniques.isEmpty()) continue;
                uniques.put(entry.getKey(), subUniques);
                continue;
            }
            if (rawValue1.equals(rawValue2)) continue;
            uniques.put(entry.getKey(), entry.getValue());
        }
        return uniques;
    }

    private static void uncheckedPut(Map map, Object key, Object value) {
        map.put(key, value);
    }

    @Generated
    private MapOps() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

