/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.collections;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;

public final class Lists {
    public static <T> List<T> moveToBottom(List<T> list, T input) {
        if (list.size() > 1 && list.indexOf(input) < list.size() - 1) {
            list.remove(input);
            list.add(list.size(), input);
        }
        return list;
    }

    @SafeVarargs
    public static <T> List<T> merge(List<T> list, List<T> ... others) {
        ArrayList<T> newList = new ArrayList<T>(list);
        for (List<T> other : others) {
            newList.addAll(other);
        }
        return newList;
    }

    @SafeVarargs
    public static <T extends List<O>, O> T any(Supplier<T> listSupplier, O ... objects) {
        List list = (List)listSupplier.get();
        Collections.addAll(list, objects);
        return (T)list;
    }

    public static <T extends List<O>, O> T any(Supplier<T> listSupplier, Consumer<T> listConsumer) {
        List list = (List)listSupplier.get();
        listConsumer.accept(list);
        return (T)list;
    }

    @SafeVarargs
    public static <O> ArrayList<O> arrayList(O ... objects) {
        return Lists.any(ArrayList::new, objects);
    }

    public static <O> ArrayList<O> arrayList(Consumer<ArrayList<O>> listConsumer) {
        return Lists.any(ArrayList::new, listConsumer);
    }

    @SafeVarargs
    public static <O> CopyOnWriteArrayList<O> copyOnWriteArrayList(O ... objects) {
        return Lists.any(CopyOnWriteArrayList::new, objects);
    }

    public static <O> CopyOnWriteArrayList<O> copyOnWriteArrayList(Consumer<CopyOnWriteArrayList<O>> listConsumer) {
        return Lists.any(CopyOnWriteArrayList::new, listConsumer);
    }

    @Generated
    private Lists() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

