/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm.provider.io;

import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.lenni0451.commons.asm.ASMUtils;
import net.lenni0451.commons.asm.provider.ClassProvider;

public class PathClassProvider
implements ClassProvider {
    private final Path path;

    public PathClassProvider(Path path) {
        this.path = path;
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    @Nonnull
    public byte[] getClass(String name) throws ClassNotFoundException {
        try {
            Path file = this.path.resolve(ASMUtils.slash(name) + ".class");
            if (Files.exists(file, new LinkOption[0])) {
                return Files.readAllBytes(file);
            }
        }
        catch (Throwable t) {
            throw new ClassNotFoundException(name, t);
        }
        throw new ClassNotFoundException(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nonnull
    public Map<String, ClassProvider.ClassSupplier> getAllClasses() {
        try (Stream<Path> paths = Files.find(this.path, Integer.MAX_VALUE, this::isClass, new FileVisitOption[0]);){
            Map map = paths.collect(HashMap::new, (m, p) -> {
                String name = this.path.relativize((Path)p).toString();
                name = name.substring(0, name.length() - 6);
                m.put(name.replace("\\", "/"), () -> Files.readAllBytes(p));
            }, Map::putAll);
            return map;
        }
    }

    private boolean isClass(Path path, BasicFileAttributes attributes) {
        Path fileName = path.getFileName();
        if (fileName == null) {
            return false;
        }
        return fileName.toString().toLowerCase(Locale.ROOT).endsWith(".class") && attributes.isRegularFile();
    }
}

