/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm.provider.io;

import java.io.File;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.util.Collection;
import java.util.Collections;
import net.lenni0451.commons.asm.provider.ClassProvider;
import net.lenni0451.commons.asm.provider.DelegatingClassProvider;
import net.lenni0451.commons.asm.provider.LazyClassProvider;
import net.lenni0451.commons.asm.provider.io.FileSystemClassProvider;

public class JarFileClassProvider
extends FileSystemClassProvider {
    public static ClassProvider lazyDelegating(Collection<File> jarFiles) {
        ClassProvider[] providers = new ClassProvider[jarFiles.size()];
        int i = 0;
        for (File jarFile : jarFiles) {
            providers[i++] = new LazyClassProvider(() -> new JarFileClassProvider(jarFile));
        }
        return new DelegatingClassProvider(providers);
    }

    public JarFileClassProvider(File jarFile) {
        super(JarFileClassProvider.openFileSystem(jarFile), true);
    }

    private static FileSystem openFileSystem(File jarFile) {
        URI uri = new URI("jar:" + jarFile.toURI());
        try {
            return FileSystems.getFileSystem(uri);
        }
        catch (FileSystemNotFoundException e) {
            return FileSystems.newFileSystem(uri, Collections.emptyMap());
        }
    }
}

