/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm.provider.instrumentation;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.lenni0451.commons.asm.provider.ClassProvider;
import net.lenni0451.commons.asm.provider.DelegatingClassProvider;
import net.lenni0451.commons.asm.provider.LoaderClassProvider;

public class InstrumentationLoaderClassProvider
implements ClassProvider,
ClassFileTransformer {
    private final Instrumentation instrumentation;
    private final Map<ClassLoader, LoaderClassProvider> classLoaders;
    private DelegatingClassProvider classProvider;

    public InstrumentationLoaderClassProvider(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
        this.classLoaders = new ConcurrentHashMap<ClassLoader, LoaderClassProvider>();
        this.classLoaders.put(ClassLoader.getSystemClassLoader(), new LoaderClassProvider(ClassLoader.getSystemClassLoader()));
        this.setupInstrumentation();
    }

    @Override
    @Nonnull
    public byte[] getClass(String name) throws ClassNotFoundException {
        return this.classProvider.getClass(name);
    }

    @Override
    @Nonnull
    public Map<String, ClassProvider.ClassSupplier> getAllClasses() throws UnsupportedOperationException {
        return this.classProvider.getAllClasses();
    }

    @Override
    public void close() throws Exception {
        this.instrumentation.removeTransformer(this);
        this.classLoaders.clear();
        this.classProvider.close();
        this.classProvider = null;
    }

    private void setupInstrumentation() {
        this.instrumentation.addTransformer(this, true);
        for (Class clazz : this.instrumentation.getAllLoadedClasses()) {
            if (clazz == null || clazz.getClassLoader() == null) continue;
            this.classLoaders.computeIfAbsent(clazz.getClassLoader(), LoaderClassProvider::new);
        }
        this.updateClassProvider();
    }

    private synchronized void updateClassProvider() {
        this.classProvider = new DelegatingClassProvider(this.classLoaders.values().toArray(new ClassProvider[0]));
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        if (loader != null && !this.classLoaders.containsKey(loader)) {
            this.classLoaders.computeIfAbsent(loader, LoaderClassProvider::new);
            this.updateClassProvider();
        }
        return null;
    }
}

