/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm.provider.instrumentation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.lenni0451.commons.asm.ASMUtils;
import net.lenni0451.commons.asm.io.ClassIO;
import net.lenni0451.commons.asm.provider.ClassProvider;
import org.objectweb.asm.tree.ClassNode;

public class InstrumentationCacheClassProvider
implements ClassProvider,
ClassFileTransformer {
    private final Instrumentation instrumentation;
    private final Map<String, ClassProvider.ClassSupplier> classes;

    public InstrumentationCacheClassProvider(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
        this.classes = new ConcurrentHashMap<String, ClassProvider.ClassSupplier>();
        this.setupInstrumentation();
    }

    @Override
    @Nonnull
    public byte[] getClass(String name) throws ClassNotFoundException {
        try {
            ClassProvider.ClassSupplier supplier = this.classes.get(ASMUtils.slash(name));
            if (supplier == null) {
                throw new ClassNotFoundException(name);
            }
            return supplier.get();
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    @Override
    @Nonnull
    public Map<String, ClassProvider.ClassSupplier> getAllClasses() throws UnsupportedOperationException {
        return Collections.unmodifiableMap(this.classes);
    }

    @Override
    public void close() {
        this.instrumentation.removeTransformer(this);
        this.classes.clear();
    }

    private void setupInstrumentation() {
        this.instrumentation.addTransformer(this, true);
        for (Class clazz : this.instrumentation.getAllLoadedClasses()) {
            if (clazz == null || clazz.isArray()) continue;
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            try {
                int len;
                InputStream is = classLoader.getResourceAsStream(ASMUtils.slash(clazz.getName()) + ".class");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((len = is.read(buffer)) >= 0) {
                    baos.write(buffer, 0, len);
                }
                this.classes.put(ASMUtils.slash(clazz.getName()), baos::toByteArray);
            }
            catch (Throwable t) {
                try {
                    this.instrumentation.retransformClasses(clazz);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        if (className == null) {
            try {
                ClassNode node = ClassIO.fromBytes(classfileBuffer, 7);
                this.classes.put(node.name, () -> classfileBuffer);
            }
            catch (Throwable throwable) {}
        } else {
            this.classes.put(ASMUtils.slash(className), () -> classfileBuffer);
        }
        return null;
    }
}

