/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm.provider;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.lenni0451.commons.asm.ASMUtils;
import net.lenni0451.commons.asm.provider.ClassProvider;

public class MapClassProvider
implements ClassProvider {
    private final Map<String, byte[]> classes;
    private final NameFormat nameFormat;

    public MapClassProvider(Map<String, byte[]> classes, NameFormat nameFormat) {
        this.classes = classes;
        this.nameFormat = nameFormat;
    }

    public Map<String, byte[]> getClasses() {
        return this.classes;
    }

    @Override
    @Nonnull
    public byte[] getClass(String name) throws ClassNotFoundException {
        String formattedName = this.nameFormat.format(name);
        byte[] clazz = this.classes.get(formattedName);
        if (clazz != null) {
            return clazz;
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    @Nonnull
    public Map<String, ClassProvider.ClassSupplier> getAllClasses() {
        HashMap<String, ClassProvider.ClassSupplier> classes = new HashMap<String, ClassProvider.ClassSupplier>();
        for (Map.Entry<String, byte[]> entry : this.classes.entrySet()) {
            classes.put(this.nameFormat.toSlash(entry.getKey()), entry::getValue);
        }
        return classes;
    }

    public static enum NameFormat {
        SLASH(ASMUtils::slash, ASMUtils::dot),
        DOT(ASMUtils::dot, Function.identity()),
        SLASH_CLASS(name -> ASMUtils.slash(name) + ".class", name -> ASMUtils.dot(name).substring(0, name.length() - 6)),
        DOT_CLASS(name -> ASMUtils.dot(name) + ".class", name -> name.substring(0, name.length() - 6));

        private final Function<String, String> formatter;
        private final Function<String, String> toSlash;

        private NameFormat(Function<String, String> formatter, Function<String, String> toSlash) {
            this.formatter = formatter;
            this.toSlash = toSlash;
        }

        public String format(String name) {
            return this.formatter.apply(name);
        }

        public String toSlash(String name) {
            return this.toSlash.apply(name);
        }
    }
}

