/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm.provider;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.annotation.Nonnull;
import net.lenni0451.commons.asm.ASMUtils;
import net.lenni0451.commons.asm.provider.ClassProvider;

public class LoaderClassProvider
implements ClassProvider {
    private ClassLoader classLoader;

    public LoaderClassProvider() {
        this(LoaderClassProvider.class.getClassLoader());
    }

    public LoaderClassProvider(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nonnull
    public byte[] getClass(String name) throws ClassNotFoundException {
        try (InputStream is = this.classLoader.getResourceAsStream(ASMUtils.slash(name) + ".class");){
            int len;
            if (is == null) {
                throw new NullPointerException("Class input stream is null");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) > 0) {
                baos.write(buf, 0, len);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Throwable t) {
            throw new ClassNotFoundException(name, t);
        }
    }
}

