/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm.provider;

import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.lenni0451.commons.asm.provider.ClassProvider;

public class LazyClassProvider
implements ClassProvider {
    private final Supplier<ClassProvider> supplier;
    private ClassProvider delegate;

    public LazyClassProvider(Supplier<ClassProvider> supplier) {
        this.supplier = supplier;
    }

    @Override
    @Nonnull
    public byte[] getClass(String name) throws ClassNotFoundException {
        if (this.delegate == null) {
            this.delegate = this.supplier.get();
        }
        return this.delegate.getClass(name);
    }

    @Override
    @Nonnull
    public Map<String, ClassProvider.ClassSupplier> getAllClasses() throws UnsupportedOperationException {
        if (this.delegate == null) {
            this.delegate = this.supplier.get();
        }
        return this.delegate.getAllClasses();
    }

    @Override
    public void close() throws Exception {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }
}

