/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm.provider;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.lenni0451.commons.asm.provider.ClassProvider;

public class DelegatingClassProvider
implements ClassProvider {
    private final ClassProvider[] delegates;

    public DelegatingClassProvider(ClassProvider ... delegates) {
        this.delegates = delegates;
    }

    @Override
    @Nonnull
    public byte[] getClass(String name) throws ClassNotFoundException {
        for (ClassProvider delegate : this.delegates) {
            try {
                return delegate.getClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    @Nonnull
    public Map<String, ClassProvider.ClassSupplier> getAllClasses() {
        HashMap<String, ClassProvider.ClassSupplier> classes = new HashMap<String, ClassProvider.ClassSupplier>();
        boolean supported = false;
        for (ClassProvider delegate : this.delegates) {
            try {
                classes.putAll(delegate.getAllClasses());
                supported = true;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        if (!supported) {
            throw new UnsupportedOperationException("getAllClasses is not supported by any delegate");
        }
        return classes;
    }

    @Override
    public void close() throws Exception {
        Exception exception = null;
        for (ClassProvider delegate : this.delegates) {
            try {
                delegate.close();
            }
            catch (Exception e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

