/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm.provider;

import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import net.lenni0451.commons.asm.io.ClassIO;
import net.lenni0451.commons.asm.provider.DelegatingClassProvider;
import org.objectweb.asm.tree.ClassNode;

public interface ClassProvider
extends AutoCloseable {
    @Nonnull
    public byte[] getClass(String var1) throws ClassNotFoundException;

    @Nonnull
    default public Map<String, ClassSupplier> getAllClasses() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void close() throws Exception {
    }

    default public ClassNode getClassNode(String name) throws ClassNotFoundException {
        return ClassIO.fromBytes(this.getClass(name));
    }

    default public ClassProvider then(ClassProvider ... classProviders) {
        if (classProviders.length == 0) {
            return this;
        }
        ClassProvider[] providers = new ClassProvider[classProviders.length + 1];
        providers[0] = this;
        System.arraycopy(classProviders, 0, providers, 1, classProviders.length);
        return new DelegatingClassProvider(providers);
    }

    @FunctionalInterface
    public static interface ClassSupplier {
        public byte[] get() throws IOException;
    }
}

