/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm.mappings.loader.formats;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import net.lenni0451.commons.asm.mappings.Mappings;
import net.lenni0451.commons.asm.mappings.loader.MappingsLoader;
import net.lenni0451.commons.asm.mappings.meta.ClassMetaMapping;
import net.lenni0451.commons.asm.mappings.meta.FieldMetaMapping;
import net.lenni0451.commons.asm.mappings.meta.MethodMetaMapping;
import net.lenni0451.commons.asm.mappings.meta.ParameterMetaMapping;

public class TinyV2MappingsLoader
extends MappingsLoader {
    private static final String[] EMPTY_JAVADOC = new String[0];
    private final String fromNamespace;
    private final String toNamespace;
    private final List<ClassMetaMapping> metaMappings = new ArrayList<ClassMetaMapping>();
    private boolean parseMeta = false;
    private ClassMetaMapping currentClassMeta = null;
    private FieldMetaMapping currentFieldMeta = null;
    private MethodMetaMapping currentMethodMeta = null;
    private ParameterMetaMapping currentParameterMeta = null;

    public TinyV2MappingsLoader(InputStream inputStream, String fromNamespace, String toNamespace) {
        super(inputStream);
        this.fromNamespace = fromNamespace;
        this.toNamespace = toNamespace;
    }

    public TinyV2MappingsLoader(File file, String fromNamespace, String toNamespace) {
        super(file);
        this.fromNamespace = fromNamespace;
        this.toNamespace = toNamespace;
    }

    public TinyV2MappingsLoader(Path path, String fromNamespace, String toNamespace) {
        super(path);
        this.fromNamespace = fromNamespace;
        this.toNamespace = toNamespace;
    }

    public TinyV2MappingsLoader enableMetaParsing() {
        this.parseMeta = true;
        return this;
    }

    @Override
    public List<ClassMetaMapping> getMetaMappings() {
        if (!this.parseMeta) {
            throw new IllegalStateException("Meta parsing is disabled");
        }
        this.getMappings();
        return this.metaMappings;
    }

    @Override
    protected Mappings load(List<String> lines) {
        Mappings mappings = new Mappings();
        Mappings baseToSource = new Mappings();
        Mappings baseToTarget = new Mappings();
        ArrayList<UnmappedMember> unmappedMembers = new ArrayList<UnmappedMember>();
        int fromIndex = -1;
        int toIndex = -1;
        String currentClass = null;
        for (String line : lines) {
            String toName;
            String fromName;
            String[] parts = line.replaceAll("\\s{2,}", "\t").replaceAll("^\\s+", "").split("\t", -1);
            if (fromIndex == -1) {
                if (!parts[0].equals("tiny")) {
                    throw new IllegalStateException("Invalid tiny header (expected 'tiny', got '" + parts[0] + "')");
                }
                if (!parts[1].equals("2")) {
                    throw new IllegalStateException("Invalid tiny major version (expected '2', got '" + parts[1] + "')");
                }
                if (!parts[2].equals("0")) {
                    throw new IllegalStateException("Invalid tiny minor version (expected '0', got '" + parts[2] + "')");
                }
                if (parts.length < 5) {
                    throw new IllegalStateException("Invalid tiny header (missing namespaces)");
                }
                List<String> namespaces = Arrays.asList(Arrays.copyOfRange(parts, 3, parts.length));
                fromIndex = namespaces.indexOf(this.fromNamespace);
                toIndex = namespaces.indexOf(this.toNamespace);
                if (fromIndex == -1) {
                    throw new IllegalStateException("Namespace '" + this.fromNamespace + "' not found in tiny mappings (available: " + namespaces + ")");
                }
                if (toIndex != -1) continue;
                throw new IllegalStateException("Namespace '" + this.toNamespace + "' not found in tiny mappings (available: " + namespaces + ")");
            }
            if (line.startsWith("c\t")) {
                String baseName = parts[1];
                currentClass = parts[1 + fromIndex];
                String toName2 = parts[1 + toIndex];
                if (toName2.isEmpty()) {
                    toName2 = currentClass;
                }
                baseToSource.addClassMapping(baseName, currentClass);
                baseToTarget.addClassMapping(baseName, toName2);
                mappings.addClassMapping(currentClass, toName2);
                if (!this.parseMeta) continue;
                this.updateMeta(UpdateLevel.CLASS);
                this.currentClassMeta = new ClassMetaMapping(toName2, EMPTY_JAVADOC, new ArrayList<FieldMetaMapping>(), new ArrayList<MethodMetaMapping>());
                continue;
            }
            if (line.startsWith("\tf\t")) {
                if (currentClass == null) {
                    throw new IllegalStateException("Field mapping without class mapping");
                }
                String descriptor = parts[1];
                fromName = parts[2 + fromIndex];
                toName = parts[2 + toIndex];
                if (toName.isEmpty()) {
                    toName = fromName;
                }
                unmappedMembers.add(new UnmappedMember(false, currentClass, fromName, descriptor, toName));
                if (!this.parseMeta) continue;
                this.updateMeta(UpdateLevel.FIELD);
                this.currentFieldMeta = new FieldMetaMapping(toName, descriptor, EMPTY_JAVADOC);
                continue;
            }
            if (line.startsWith("\tm\t")) {
                if (currentClass == null) {
                    throw new IllegalStateException("Method mapping without class mapping");
                }
                String descriptor = parts[1];
                fromName = parts[2 + fromIndex];
                toName = parts[2 + toIndex];
                if (toName.isEmpty()) {
                    toName = fromName;
                }
                unmappedMembers.add(new UnmappedMember(true, currentClass, fromName, descriptor, toName));
                if (!this.parseMeta) continue;
                this.updateMeta(UpdateLevel.METHOD);
                this.currentMethodMeta = new MethodMetaMapping(toName, descriptor, EMPTY_JAVADOC, new ArrayList<ParameterMetaMapping>());
                continue;
            }
            if (line.startsWith("\t\tp")) {
                if (!this.parseMeta) continue;
                if (this.currentMethodMeta == null) {
                    throw new IllegalStateException("Parameter mapping without method mapping");
                }
                int index = Integer.parseInt(parts[1]);
                String name = parts[2];
                this.updateMeta(UpdateLevel.PARAMETER);
                this.currentParameterMeta = new ParameterMetaMapping(index, name, EMPTY_JAVADOC);
                continue;
            }
            if (line.startsWith("\tc")) {
                if (!this.parseMeta) continue;
                if (this.currentClassMeta == null) {
                    throw new IllegalStateException("Comment without class mapping");
                }
                String comment = String.join((CharSequence)"\t", Arrays.copyOfRange(parts, 1, parts.length));
                this.currentClassMeta = this.currentClassMeta.withJavadoc(comment.split(Pattern.quote("\\n")));
                continue;
            }
            if (line.startsWith("\t\tc")) {
                if (!this.parseMeta) continue;
                if (this.currentFieldMeta != null && this.currentMethodMeta != null) {
                    throw new IllegalStateException("Field and method meta at the same time");
                }
                if (this.currentFieldMeta != null) {
                    String comment = String.join((CharSequence)"\t", Arrays.copyOfRange(parts, 1, parts.length));
                    this.currentFieldMeta = this.currentFieldMeta.withJavadoc(comment.split(Pattern.quote("\\n")));
                    continue;
                }
                if (this.currentMethodMeta != null) {
                    String comment = String.join((CharSequence)"\t", Arrays.copyOfRange(parts, 1, parts.length));
                    this.currentMethodMeta = this.currentMethodMeta.withJavadoc(comment.split(Pattern.quote("\\n")));
                    continue;
                }
                throw new IllegalStateException("Comment without field or method mapping");
            }
            if (line.startsWith("\t\t\tc")) {
                if (!this.parseMeta) continue;
                if (this.currentParameterMeta == null) {
                    throw new IllegalStateException("Comment without parameter mapping");
                }
                String comment = String.join((CharSequence)"\t", Arrays.copyOfRange(parts, 1, parts.length));
                this.currentParameterMeta = this.currentParameterMeta.withJavadoc(comment.split(Pattern.quote("\\n")));
                continue;
            }
            throw new IllegalStateException("Unknown line: " + line);
        }
        this.updateMeta(UpdateLevel.CLASS);
        this.finalizeMemberMappings(mappings, baseToSource, unmappedMembers);
        if (this.parseMeta) {
            this.finalizeMetaMappings(baseToTarget);
        }
        return mappings;
    }

    private void finalizeMemberMappings(Mappings mappings, Mappings baseToSource, List<UnmappedMember> unmappedMembers) {
        for (UnmappedMember member : unmappedMembers) {
            if (member.method) {
                mappings.addMethodMapping(member.owner, member.name, baseToSource.mapMethodDesc(member.descriptor), member.toName);
                continue;
            }
            mappings.addFieldMapping(member.owner, member.name, baseToSource.mapDesc(member.descriptor), member.toName);
        }
    }

    private void finalizeMetaMappings(Mappings baseToTarget) {
        ArrayList<ClassMetaMapping> remappedMetaMappings = new ArrayList<ClassMetaMapping>();
        for (ClassMetaMapping classMeta : this.metaMappings) {
            remappedMetaMappings.add(classMeta);
            ArrayList<FieldMetaMapping> fieldMetas = new ArrayList<FieldMetaMapping>();
            for (FieldMetaMapping field : classMeta.getFields()) {
                fieldMetas.add(field.withDescriptor(baseToTarget.mapDesc(field.getDescriptor())));
            }
            classMeta.getFields().clear();
            classMeta.getFields().addAll(fieldMetas);
            ArrayList<MethodMetaMapping> methodMetas = new ArrayList<MethodMetaMapping>();
            for (MethodMetaMapping method : classMeta.getMethods()) {
                methodMetas.add(method.withDescriptor(baseToTarget.mapMethodDesc(method.getDescriptor())));
            }
            classMeta.getMethods().clear();
            classMeta.getMethods().addAll(methodMetas);
        }
        this.metaMappings.clear();
        this.metaMappings.addAll(remappedMetaMappings);
    }

    private void updateMeta(UpdateLevel level) {
        UpdateLevel[] updates;
        switch (level) {
            case CLASS: {
                updates = new UpdateLevel[]{UpdateLevel.PARAMETER, UpdateLevel.METHOD, UpdateLevel.FIELD, UpdateLevel.CLASS};
                break;
            }
            case FIELD: 
            case METHOD: {
                updates = new UpdateLevel[]{UpdateLevel.PARAMETER, UpdateLevel.METHOD, UpdateLevel.FIELD};
                break;
            }
            case PARAMETER: {
                updates = new UpdateLevel[]{UpdateLevel.PARAMETER};
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown update level: " + (Object)((Object)level));
            }
        }
        block11: for (UpdateLevel update : updates) {
            switch (update) {
                case CLASS: {
                    if (this.currentClassMeta != null && !this.currentClassMeta.isEmpty()) {
                        this.metaMappings.add(this.currentClassMeta);
                    }
                    this.currentClassMeta = null;
                    continue block11;
                }
                case FIELD: {
                    if (this.currentFieldMeta != null && !this.currentFieldMeta.isEmpty()) {
                        this.currentClassMeta.getFields().add(this.currentFieldMeta);
                    }
                    this.currentFieldMeta = null;
                    continue block11;
                }
                case METHOD: {
                    if (this.currentMethodMeta != null && !this.currentMethodMeta.isEmpty()) {
                        this.currentClassMeta.getMethods().add(this.currentMethodMeta);
                    }
                    this.currentMethodMeta = null;
                    continue block11;
                }
                case PARAMETER: {
                    if (this.currentParameterMeta != null) {
                        this.currentMethodMeta.getParameters().add(this.currentParameterMeta);
                    }
                    this.currentParameterMeta = null;
                }
            }
        }
    }

    private static enum UpdateLevel {
        CLASS,
        FIELD,
        METHOD,
        PARAMETER;

    }

    private static class UnmappedMember {
        private final boolean method;
        private final String owner;
        private final String name;
        private final String descriptor;
        private final String toName;

        @Generated
        public UnmappedMember(boolean method, String owner, String name, String descriptor, String toName) {
            this.method = method;
            this.owner = owner;
            this.name = name;
            this.descriptor = descriptor;
            this.toName = toName;
        }
    }
}

