/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm.mappings.loader.formats;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import net.lenni0451.commons.asm.mappings.Mappings;
import net.lenni0451.commons.asm.mappings.loader.MappingsLoader;

public class TinyV1MappingsLoader
extends MappingsLoader {
    private final String fromNamespace;
    private final String toNamespace;

    public TinyV1MappingsLoader(InputStream inputStream, String fromNamespace, String toNamespace) {
        super(inputStream);
        this.fromNamespace = fromNamespace;
        this.toNamespace = toNamespace;
    }

    public TinyV1MappingsLoader(File file, String fromNamespace, String toNamespace) {
        super(file);
        this.fromNamespace = fromNamespace;
        this.toNamespace = toNamespace;
    }

    public TinyV1MappingsLoader(Path path, String fromNamespace, String toNamespace) {
        super(path);
        this.fromNamespace = fromNamespace;
        this.toNamespace = toNamespace;
    }

    @Override
    protected Mappings load(List<String> lines) {
        Mappings mappings = new Mappings();
        Mappings baseToSource = new Mappings();
        ArrayList<UnmappedMember> unmappedMembers = new ArrayList<UnmappedMember>();
        int fromIndex = -1;
        int toIndex = -1;
        for (String line : lines) {
            String toName;
            String fromName;
            String descriptor;
            String owner;
            String[] parts = line.trim().split("\t+");
            if (fromIndex == -1) {
                if (!parts[0].equals("v1")) {
                    throw new IllegalStateException("Invalid tiny header (expected 'v1', got '" + parts[0] + "')");
                }
                if (parts.length < 3) {
                    throw new IllegalStateException("Invalid tiny header (missing namespaces)");
                }
                List<String> namespaces = Arrays.asList(Arrays.copyOfRange(parts, 1, parts.length));
                fromIndex = namespaces.indexOf(this.fromNamespace);
                toIndex = namespaces.indexOf(this.toNamespace);
                if (fromIndex == -1) {
                    throw new IllegalStateException("Namespace '" + this.fromNamespace + "' not found in tiny mappings (available: " + namespaces + ")");
                }
                if (toIndex != -1) continue;
                throw new IllegalStateException("Namespace '" + this.toNamespace + "' not found in tiny mappings (available: " + namespaces + ")");
            }
            if (line.startsWith("CLASS\t")) {
                String baseName = parts[1];
                String fromName2 = parts[1 + fromIndex];
                String toName2 = parts[1 + toIndex];
                baseToSource.addClassMapping(baseName, fromName2);
                mappings.addClassMapping(fromName2, toName2);
                continue;
            }
            if (line.startsWith("FIELD\t")) {
                owner = parts[1];
                descriptor = parts[2];
                fromName = parts[3 + fromIndex];
                toName = parts[3 + toIndex];
                unmappedMembers.add(new UnmappedMember(false, owner, fromName, descriptor, toName));
                continue;
            }
            if (line.startsWith("METHOD\t")) {
                owner = parts[1];
                descriptor = parts[2];
                fromName = parts[3 + fromIndex];
                toName = parts[3 + toIndex];
                unmappedMembers.add(new UnmappedMember(true, owner, fromName, descriptor, toName));
                continue;
            }
            throw new IllegalStateException("Unknown line: " + line);
        }
        this.finalizeMemberMappings(mappings, baseToSource, unmappedMembers);
        return mappings;
    }

    private void finalizeMemberMappings(Mappings mappings, Mappings baseToSource, List<UnmappedMember> unmappedMembers) {
        for (UnmappedMember member : unmappedMembers) {
            if (member.method) {
                mappings.addMethodMapping(baseToSource.map(member.owner), member.name, baseToSource.mapMethodDesc(member.descriptor), member.toName);
                continue;
            }
            mappings.addFieldMapping(baseToSource.map(member.owner), member.name, baseToSource.mapDesc(member.descriptor), member.toName);
        }
    }

    private static class UnmappedMember {
        private final boolean method;
        private final String owner;
        private final String name;
        private final String descriptor;
        private final String toName;

        @Generated
        public UnmappedMember(boolean method, String owner, String name, String descriptor, String toName) {
            this.method = method;
            this.owner = owner;
            this.name = name;
            this.descriptor = descriptor;
            this.toName = toName;
        }
    }
}

