/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm.mappings.loader.formats;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import net.lenni0451.commons.asm.mappings.Mappings;
import net.lenni0451.commons.asm.mappings.loader.MappingsLoader;

public class SrgMappingsLoader
extends MappingsLoader {
    public SrgMappingsLoader(InputStream inputStream) {
        super(inputStream);
    }

    public SrgMappingsLoader(File file) {
        super(file);
    }

    public SrgMappingsLoader(Path path) {
        super(path);
    }

    @Override
    protected Mappings load(List<String> lines) {
        Mappings mappings = new Mappings();
        for (String line : lines) {
            String newName;
            String desc;
            String name;
            String owner;
            String newName2;
            String name2;
            String[] parts = line.trim().split(" ");
            for (int i = 0; i < parts.length; ++i) {
                if (!parts[i].startsWith("#")) continue;
                parts = Arrays.copyOf(parts, i);
                break;
            }
            if (parts[0].equals("PK:")) {
                name2 = parts[1];
                newName2 = parts[2];
                mappings.addPackageMapping(name2, newName2);
                continue;
            }
            if (parts[0].equals("CL:")) {
                name2 = parts[1];
                newName2 = parts[2];
                mappings.addClassMapping(name2, newName2);
                continue;
            }
            if (parts[0].equals("FD:")) {
                if (parts.length == 3) {
                    owner = parts[1].substring(0, parts[1].lastIndexOf(47));
                    name = parts[1].substring(parts[1].lastIndexOf(47) + 1);
                    String newName3 = parts[2].substring(parts[2].lastIndexOf(47) + 1);
                    mappings.addFieldMapping(owner, name, null, newName3);
                    continue;
                }
                if (parts.length == 5) {
                    owner = parts[1].substring(0, parts[1].lastIndexOf(47));
                    name = parts[1].substring(parts[1].lastIndexOf(47) + 1);
                    desc = parts[2];
                    newName = parts[3].substring(parts[3].lastIndexOf(47) + 1);
                    mappings.addFieldMapping(owner, name, desc, newName);
                    continue;
                }
                throw new IllegalStateException("Invalid field line: " + line);
            }
            if (parts[0].equals("MD:")) {
                if (parts.length == 4 || parts.length == 5) {
                    owner = parts[1].substring(0, parts[1].lastIndexOf(47));
                    name = parts[1].substring(parts[1].lastIndexOf(47) + 1);
                    desc = parts[2];
                    newName = parts[3].substring(parts[3].lastIndexOf(47) + 1);
                    mappings.addMethodMapping(owner, name, desc, newName);
                    continue;
                }
                throw new IllegalStateException("Invalid method line: " + line);
            }
            throw new IllegalStateException("Unknown line: " + line);
        }
        return mappings;
    }
}

