/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.asm.mappings.loader.formats;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import net.lenni0451.commons.asm.mappings.Mappings;
import net.lenni0451.commons.asm.mappings.loader.MappingsLoader;

public class RetroguardMappingsLoader
extends MappingsLoader {
    public RetroguardMappingsLoader(InputStream inputStream) {
        super(inputStream);
    }

    public RetroguardMappingsLoader(File file) {
        super(file);
    }

    public RetroguardMappingsLoader(Path path) {
        super(path);
    }

    @Override
    protected Mappings load(List<String> lines) {
        Mappings mappings = new Mappings();
        for (String line : lines) {
            String name;
            String owner;
            String[] parts = line.trim().split(" ");
            if (parts[0].equals(".class_map")) {
                String name2 = parts[1];
                String newName = parts[2];
                mappings.addClassMapping(name2, newName);
                continue;
            }
            if (parts[0].equals(".field_map")) {
                owner = parts[1].substring(0, parts[1].lastIndexOf(47));
                name = parts[1].substring(parts[1].lastIndexOf(47) + 1);
                String newName = parts[2];
                mappings.addFieldMapping(owner, name, null, newName);
                continue;
            }
            if (!parts[0].equals(".method_map")) continue;
            owner = parts[1].substring(0, parts[1].lastIndexOf(47));
            name = parts[1].substring(parts[1].lastIndexOf(47) + 1);
            String desc = parts[2];
            String newName = parts[3];
            mappings.addMethodMapping(owner, name, desc, newName);
        }
        return mappings;
    }
}

